/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.netty;

import io.netty.channel.Channel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.PlatformDependent;
import java.net.SocketAddress;
import java.util.Deque;
import java.util.NoSuchElementException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.StampedLock;
import java.util.function.BiConsumer;
import org.infinispan.client.hotrod.configuration.ExhaustedAction;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelInitializer;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelOperation;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelPoolCloseEvent;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelRecord;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

class ChannelPool {
    private static final AtomicIntegerFieldUpdater<TimeoutCallback> invokedUpdater = AtomicIntegerFieldUpdater.newUpdater(TimeoutCallback.class, "invoked");
    private static final Log log = LogFactory.getLog(ChannelPool.class);
    private static final int MAX_FULL_CHANNELS_SEEN = 10;
    private final Deque<Channel> channels = PlatformDependent.newConcurrentDeque();
    private final Deque<ChannelOperation> callbacks = PlatformDependent.newConcurrentDeque();
    private final EventExecutor executor;
    private final SocketAddress address;
    private final ChannelInitializer newChannelInvoker;
    private final ExhaustedAction exhaustedAction;
    private final BiConsumer<ChannelPool, ChannelEventType> connectionFailureListener;
    private final long maxWait;
    private final int maxConnections;
    private final int maxPendingRequests;
    private final AtomicInteger created = new AtomicInteger();
    private final AtomicInteger active = new AtomicInteger();
    private final AtomicInteger connected = new AtomicInteger();
    private final StampedLock lock = new StampedLock();
    private volatile boolean terminated = false;

    ChannelPool(EventExecutor executor, SocketAddress address, ChannelInitializer newChannelInvoker, ExhaustedAction exhaustedAction, BiConsumer<ChannelPool, ChannelEventType> connectionFailureListener, long maxWait, int maxConnections, int maxPendingRequests) {
        this.connectionFailureListener = connectionFailureListener;
        this.executor = executor;
        this.address = address;
        this.newChannelInvoker = newChannelInvoker;
        this.exhaustedAction = exhaustedAction;
        this.maxWait = maxWait;
        this.maxConnections = maxConnections;
        this.maxPendingRequests = maxPendingRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(ChannelOperation callback) {
        Channel channel;
        if (this.terminated) {
            callback.cancel(this.address, new RejectedExecutionException("Pool was terminated"));
            return;
        }
        int fullChannelsSeen = 0;
        while ((channel = this.channels.pollFirst()) != null) {
            if (!channel.isActive()) continue;
            if (!channel.isWritable() || ((HeaderDecoder)channel.pipeline().get(HeaderDecoder.class)).registeredOperations() >= this.maxPendingRequests) {
                this.channels.addLast(channel);
                if (++fullChannelsSeen >= 10) break;
                continue;
            }
            this.activateChannel(channel, callback, false);
            return;
        }
        int current = this.created.get();
        while (current < this.maxConnections) {
            if (this.created.compareAndSet(current, current + 1)) {
                int currentActive = this.active.incrementAndGet();
                if (log.isTraceEnabled()) {
                    log.tracef("[%s] Creating new channel, created = %d, active = %d", this.address, current + 1, currentActive);
                }
                this.createAndInvoke(callback);
                return;
            }
            current = this.created.get();
        }
        switch (this.exhaustedAction) {
            case EXCEPTION: {
                throw new NoSuchElementException("Reached maximum number of connections");
            }
            case WAIT: {
                break;
            }
            case CREATE_NEW: {
                int currentCreated = this.created.incrementAndGet();
                int currentActive = this.active.incrementAndGet();
                if (log.isTraceEnabled()) {
                    log.tracef("[%s] Creating new channel, created = %d, active = %d", this.address, currentCreated, currentActive);
                }
                this.createAndInvoke(callback);
                return;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf((Object)this.exhaustedAction));
            }
        }
        if (this.maxWait > 0L) {
            TimeoutCallback timeoutCallback = new TimeoutCallback(callback);
            timeoutCallback.timeoutFuture = this.executor.schedule((Runnable)timeoutCallback, this.maxWait, TimeUnit.MILLISECONDS);
            callback = timeoutCallback;
        }
        long stamp = this.lock.writeLock();
        try {
            do {
                if ((channel = this.channels.pollFirst()) != null) continue;
                this.callbacks.addLast(callback);
                return;
            } while (!channel.isActive());
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
        this.activateChannel(channel, callback, false);
    }

    private void createAndInvoke(ChannelOperation callback) {
        try {
            this.newChannelInvoker.createChannel().whenComplete((channel, throwable) -> {
                if (throwable != null) {
                    int currentCreated;
                    int currentActive = this.active.decrementAndGet();
                    if (currentActive < 0) {
                        Log.HOTROD.invalidActiveCountAfterClose((Channel)channel);
                    }
                    if ((currentCreated = this.created.decrementAndGet()) < 0) {
                        Log.HOTROD.invalidCreatedCountAfterClose((Channel)channel);
                    }
                    if (log.isTraceEnabled()) {
                        log.tracef((Throwable)throwable, "[%s] Channel could not be created, created = %d, active = %d, connected = %d", new Object[]{this.address, currentCreated, currentActive, this.connected.get()});
                    }
                    callback.cancel(this.address, (Throwable)throwable);
                    this.connectionFailureListener.accept(this, ChannelEventType.CONNECT_FAILED);
                } else {
                    int currentConnected = this.connected.incrementAndGet();
                    if (log.isTraceEnabled()) {
                        log.tracef("[%s] Channel connected, created = %d, active = %d, connected = %d", new Object[]{this.address, this.created.get(), this.active.get(), currentConnected});
                    }
                    callback.invoke((Channel)channel);
                    this.connectionFailureListener.accept(this, ChannelEventType.CONNECTED);
                }
            });
        }
        catch (Throwable t) {
            int currentActive = this.active.decrementAndGet();
            int currentCreated = this.created.decrementAndGet();
            if (log.isTraceEnabled()) {
                log.tracef(t, "[%s] Channel could not be created, created = %d, active = %d, connected = %d", new Object[]{this.address, currentCreated, currentActive, this.connected.get()});
            }
            if (currentCreated < 0) {
                Log.HOTROD.warnf("Invalid created count after channel create failure", new Object[0]);
            }
            if (currentActive < 0) {
                Log.HOTROD.warnf("Invalid active count after channel create failure", new Object[0]);
            }
            callback.cancel(this.address, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Channel channel, ChannelRecord record) {
        ChannelOperation callback;
        if (record.isIdle()) {
            Log.HOTROD.warnf("Cannot release channel %s because it is idle", channel);
            return;
        }
        if (record.setIdleAndIsClosed()) {
            if (log.isTraceEnabled()) {
                log.tracef("[%s] Attempt to release already closed channel %s, active = %d", this.address, channel, this.active.get());
            }
            return;
        }
        int currentActive = this.active.decrementAndGet();
        if (log.isTraceEnabled()) {
            log.tracef("[%s] Released channel %s, active = %d", this.address, channel, currentActive);
        }
        if (currentActive < 0) {
            Log.HOTROD.warnf("[%s] Invalid active count after releasing channel %s", this.address, channel);
        }
        long stamp = this.lock.readLock();
        try {
            callback = this.callbacks.pollFirst();
            if (callback == null) {
                this.channels.addFirst(channel);
                return;
            }
        }
        finally {
            this.lock.unlockRead(stamp);
        }
        this.activateChannel(channel, callback, true);
    }

    public void releaseClosedChannel(Channel channel, ChannelRecord channelRecord) {
        if (channel.isActive()) {
            Log.HOTROD.warnf("Channel %s cannot be released because it is not closed", channel);
            return;
        }
        boolean idle = channelRecord.closeAndWasIdle();
        int currentCreated = this.created.decrementAndGet();
        int currentActive = !idle ? this.active.decrementAndGet() : this.active.get();
        int currentConnected = this.connected.decrementAndGet();
        if (log.isTraceEnabled()) {
            log.tracef("[%s] Closed channel %s, created = %s, idle = %b, active = %d, connected = %d", new Object[]{this.address, channel, currentCreated, idle, currentActive, currentConnected});
        }
        if (currentCreated < 0) {
            Log.HOTROD.warnf("Invalid created count after closing channel %s", channel);
        }
        if (currentActive < 0) {
            Log.HOTROD.warnf("Invalid active count after closing channel %s", channel);
        }
        this.connectionFailureListener.accept(this, idle ? ChannelEventType.CLOSED_IDLE : ChannelEventType.CLOSED_ACTIVE);
    }

    private void activateChannel(Channel channel, ChannelOperation callback, boolean useExecutor) {
        assert (channel.isActive()) : "Channel " + channel + " is not active";
        int currentActive = this.active.incrementAndGet();
        if (log.isTraceEnabled()) {
            log.tracef("[%s] Activated record %s, created = %d, active = %d", new Object[]{this.address, channel, this.created.get(), currentActive});
        }
        ChannelRecord record = ChannelRecord.of(channel);
        record.setAcquired();
        if (useExecutor) {
            this.executor.execute(() -> {
                try {
                    callback.invoke(channel);
                }
                catch (Throwable t) {
                    log.tracef(t, "Closing channel %s due to exception", channel);
                    this.discardChannel(channel);
                }
            });
        } else {
            try {
                callback.invoke(channel);
            }
            catch (Throwable t) {
                log.tracef(t, "Closing channel %s due to exception", channel);
                this.discardChannel(channel);
                throw t;
            }
        }
    }

    private void discardChannel(Channel channel) {
        channel.close();
    }

    public SocketAddress getAddress() {
        return this.address;
    }

    public int getActive() {
        return this.active.get();
    }

    public int getIdle() {
        return Math.max(0, this.created.get() - this.active.get());
    }

    public int getConnected() {
        return this.connected.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.terminated = true;
        long stamp = this.lock.writeLock();
        try {
            RejectedExecutionException cause = new RejectedExecutionException("Pool was terminated");
            this.callbacks.forEach(callback -> callback.cancel(this.address, cause));
            this.channels.forEach(channel -> channel.pipeline().fireUserEventTriggered((Object)ChannelPoolCloseEvent.INSTANCE));
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    public String toString() {
        return "ChannelPool[address=" + this.address + ", maxWait=" + this.maxWait + ", maxConnections=" + this.maxConnections + ", maxPendingRequests=" + this.maxPendingRequests + ", created=" + this.created + ", active=" + this.active + ", connected=" + this.connected + ", terminated=" + this.terminated + "]";
    }

    private class TimeoutCallback
    implements ChannelOperation,
    Runnable {
        final ChannelOperation callback;
        volatile ScheduledFuture<?> timeoutFuture;
        volatile int invoked = 0;

        private TimeoutCallback(ChannelOperation callback) {
            this.callback = callback;
        }

        @Override
        public void run() {
            ChannelPool.this.callbacks.remove(this);
            if (invokedUpdater.compareAndSet(this, 0, 1)) {
                this.callback.cancel(ChannelPool.this.address, new TimeoutException("Timed out waiting for connection"));
            }
        }

        @Override
        public void invoke(Channel channel) {
            ScheduledFuture<?> timeoutFuture = this.timeoutFuture;
            if (timeoutFuture != null) {
                timeoutFuture.cancel(false);
            }
            if (invokedUpdater.compareAndSet(this, 0, 1)) {
                this.callback.invoke(channel);
            }
        }

        @Override
        public void cancel(SocketAddress address, Throwable cause) {
            throw new UnsupportedOperationException();
        }
    }

    static enum ChannelEventType {
        CONNECTED,
        CLOSED_IDLE,
        CLOSED_ACTIVE,
        CONNECT_FAILED;

    }
}

