/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.role.delegate;

import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.common.delegate.DelegateProvider;
import org.keycloak.models.map.role.MapRoleEntityDelegate;
import org.keycloak.models.map.storage.jpa.role.delegate.JpaRoleDelegateProvider;
import org.keycloak.models.map.storage.jpa.role.entity.JpaRoleCompositeEntity;
import org.keycloak.models.map.storage.jpa.role.entity.JpaRoleCompositeEntityKey;
import org.keycloak.models.map.storage.jpa.role.entity.JpaRoleEntity;

public class JpaMapRoleEntityDelegate
extends MapRoleEntityDelegate {
    private final EntityManager em;
    private final JpaRoleEntity original;
    private Set<String> compositeRoles;

    public void setId(String id) {
        if (super.getId() == null) {
            super.setId(id);
            this.em.persist((Object)this.original);
        } else {
            super.setId(id);
        }
    }

    public JpaMapRoleEntityDelegate(JpaRoleEntity original, EntityManager em) {
        super((DelegateProvider)new JpaRoleDelegateProvider(original, em));
        this.original = original;
        this.em = em;
    }

    public Set<String> getCompositeRoles() {
        if (this.compositeRoles == null) {
            TypedQuery query = this.em.createNamedQuery("selectChildRolesFromCompositeRole", JpaRoleCompositeEntityKey.class);
            query.setParameter("roleId", (Object)StringKeyConverter.UUIDKey.INSTANCE.fromString(this.getId()));
            this.compositeRoles = query.getResultList().stream().map(JpaRoleCompositeEntityKey::getChildRoleId).collect(Collectors.toSet());
        }
        return this.compositeRoles;
    }

    public void setCompositeRoles(Set<String> compositeRoles) {
        Query query = this.em.createNamedQuery("deleteAllChildRolesFromCompositeRole");
        query.setParameter("roleId", (Object)StringKeyConverter.UUIDKey.INSTANCE.fromString(this.getId()));
        query.executeUpdate();
        if (compositeRoles != null) {
            compositeRoles.forEach(this::addCompositeRole);
        }
        this.compositeRoles = compositeRoles;
    }

    public void addCompositeRole(String roleId) {
        JpaRoleCompositeEntityKey key = new JpaRoleCompositeEntityKey(this.getId(), roleId);
        if (this.compositeRoles != null ? this.compositeRoles.contains(roleId) : this.em.find(JpaRoleCompositeEntity.class, (Object)key) != null) {
            return;
        }
        JpaRoleCompositeEntity entity = new JpaRoleCompositeEntity(key);
        this.em.persist((Object)entity);
        if (this.compositeRoles != null) {
            this.compositeRoles.add(roleId);
        }
    }

    public void removeCompositeRole(String roleId) {
        Query query = this.em.createNamedQuery("deleteChildRoleFromCompositeRole");
        query.setParameter("roleId", (Object)StringKeyConverter.UUIDKey.INSTANCE.fromString(this.getId()));
        query.setParameter("childRoleId", (Object)roleId);
        query.executeUpdate();
        if (this.compositeRoles != null) {
            this.compositeRoles.remove(roleId);
        }
    }
}

