/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.regex.Matcher;
import org.eclipse.jetty.rewrite.handler.RedirectUtil;
import org.eclipse.jetty.rewrite.handler.RegexRule;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.Name;

public class RedirectRegexRule
extends RegexRule {
    protected String _location;
    private int _statusCode = 302;

    public RedirectRegexRule() {
        this(null, null);
    }

    public RedirectRegexRule(@Name(value="regex") String regex, @Name(value="location") String location) {
        super(regex);
        this.setHandling(true);
        this.setTerminating(true);
        this.setLocation(location);
    }

    public void setLocation(String location) {
        this._location = location;
    }

    public void setStatusCode(int statusCode) {
        if (statusCode < 300 || statusCode > 399) {
            throw new IllegalArgumentException("Invalid redirect status code " + statusCode + " (must be a value between 300 and 399)");
        }
        this._statusCode = statusCode;
    }

    @Override
    protected String apply(String target, HttpServletRequest request, HttpServletResponse response2, Matcher matcher) throws IOException {
        target = this._location;
        for (int g2 = 1; g2 <= matcher.groupCount(); ++g2) {
            String group = matcher.group(g2);
            target = StringUtil.replace(target, "$" + g2, group);
        }
        target = response2.encodeRedirectURL(target);
        response2.setHeader("Location", RedirectUtil.toRedirectURL(request, target));
        response2.setStatus(this._statusCode);
        response2.getOutputStream().flush();
        response2.getOutputStream().close();
        return target;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(super.toString());
        str.append('[').append(this._statusCode);
        str.append('>').append(this._location);
        str.append(']');
        return str.toString();
    }
}

