/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import javax.annotation.Nullable;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;
import org.gradle.tooling.internal.protocol.InternalBuildActionFailureException;
import org.gradle.tooling.internal.protocol.InternalBuildActionVersion2;
import org.gradle.tooling.internal.protocol.InternalBuildControllerVersion2;
import org.gradle.tooling.internal.protocol.InternalPhasedAction;
import org.gradle.tooling.internal.protocol.PhasedActionResult;
import org.gradle.tooling.internal.provider.ClientProvidedPhasedAction;
import org.gradle.tooling.internal.provider.PhasedBuildActionResult;
import org.gradle.tooling.internal.provider.runner.DefaultBuildController;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;

public class ClientProvidedPhasedActionRunner
implements BuildActionRunner {
    public BuildActionRunner.Result run(BuildAction action, BuildController buildController) {
        if (!(action instanceof ClientProvidedPhasedAction)) {
            return BuildActionRunner.Result.nothing();
        }
        GradleInternal gradle = buildController.getGradle();
        gradle.getStartParameter().setConfigureOnDemand(false);
        ClientProvidedPhasedAction clientProvidedPhasedAction = (ClientProvidedPhasedAction)action;
        PayloadSerializer payloadSerializer = this.getPayloadSerializer(gradle);
        InternalPhasedAction phasedAction = (InternalPhasedAction)payloadSerializer.deserialize(clientProvidedPhasedAction.getPhasedAction());
        ActionRunningListener listener = new ActionRunningListener(phasedAction, gradle);
        RuntimeException buildFailure = null;
        RuntimeException clientFailure = null;
        try {
            gradle.addBuildListener((BuildListener)listener);
            if (clientProvidedPhasedAction.isRunTasks()) {
                buildController.run();
            } else {
                buildController.configure();
            }
        }
        catch (RuntimeException e) {
            buildFailure = e;
            clientFailure = e;
        }
        if (listener.actionFailure != null) {
            clientFailure = new InternalBuildActionFailureException(listener.actionFailure);
        }
        if (buildFailure != null) {
            return BuildActionRunner.Result.failed((Throwable)buildFailure, (RuntimeException)clientFailure);
        }
        return BuildActionRunner.Result.of(null);
    }

    private PayloadSerializer getPayloadSerializer(GradleInternal gradle) {
        return (PayloadSerializer)gradle.getServices().get(PayloadSerializer.class);
    }

    private BuildEventConsumer getBuildEventConsumer(GradleInternal gradle) {
        return (BuildEventConsumer)gradle.getServices().get(BuildEventConsumer.class);
    }

    private class ActionRunningListener
    extends InternalBuildAdapter {
        private final InternalPhasedAction phasedAction;
        private final GradleInternal gradle;
        Throwable actionFailure;

        ActionRunningListener(InternalPhasedAction phasedAction, GradleInternal gradle) {
            this.phasedAction = phasedAction;
            this.gradle = gradle;
        }

        public void projectsEvaluated(Gradle gradle) {
            this.run(this.phasedAction.getProjectsLoadedAction(), PhasedActionResult.Phase.PROJECTS_LOADED);
        }

        public void buildFinished(BuildResult result) {
            if (result.getFailure() == null) {
                this.run(this.phasedAction.getBuildFinishedAction(), PhasedActionResult.Phase.BUILD_FINISHED);
            }
        }

        private void run(@Nullable InternalBuildActionVersion2<?> action, PhasedActionResult.Phase phase) {
            if (action != null) {
                SerializedPayload result = this.runAction(action, this.gradle);
                PhasedBuildActionResult res = new PhasedBuildActionResult(result, phase);
                ClientProvidedPhasedActionRunner.this.getBuildEventConsumer(this.gradle).dispatch((Object)res);
            }
        }

        private <T> SerializedPayload runAction(InternalBuildActionVersion2<T> action, GradleInternal gradle) {
            Object model;
            DefaultBuildController internalBuildController = new DefaultBuildController(gradle);
            try {
                model = action.execute((InternalBuildControllerVersion2)internalBuildController);
            }
            catch (RuntimeException e) {
                this.actionFailure = e;
                throw e;
            }
            PayloadSerializer payloadSerializer = ClientProvidedPhasedActionRunner.this.getPayloadSerializer(gradle);
            return payloadSerializer.serialize(model);
        }
    }
}

