/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;

public class CompositeResolvedArtifactSet
implements ResolvedArtifactSet {
    private final List<ResolvedArtifactSet> sets;

    private CompositeResolvedArtifactSet(List<ResolvedArtifactSet> sets) {
        this.sets = sets;
    }

    public static ResolvedArtifactSet of(Collection<? extends ResolvedArtifactSet> sets) {
        ArrayList<ResolvedArtifactSet> filtered = new ArrayList<ResolvedArtifactSet>(sets.size());
        for (ResolvedArtifactSet resolvedArtifactSet : sets) {
            if (resolvedArtifactSet == ResolvedArtifactSet.EMPTY) continue;
            filtered.add(resolvedArtifactSet);
        }
        if (filtered.isEmpty()) {
            return EMPTY;
        }
        if (filtered.size() == 1) {
            return (ResolvedArtifactSet)filtered.get(0);
        }
        return new CompositeResolvedArtifactSet(filtered);
    }

    @Override
    public ResolvedArtifactSet.Completion startVisit(BuildOperationQueue<RunnableBuildOperation> actions, ResolvedArtifactSet.AsyncArtifactListener listener) {
        ArrayList<ResolvedArtifactSet.Completion> results = new ArrayList<ResolvedArtifactSet.Completion>(this.sets.size());
        for (ResolvedArtifactSet set : this.sets) {
            results.add(set.startVisit(actions, listener));
        }
        return new CompositeResult(results);
    }

    @Override
    public void visitLocalArtifacts(ResolvedArtifactSet.LocalArtifactVisitor visitor) {
        for (ResolvedArtifactSet set : this.sets) {
            set.visitLocalArtifacts(visitor);
        }
    }

    @Override
    public void visitExternalArtifacts(Action<ResolvableArtifact> visitor) {
        for (ResolvedArtifactSet set : this.sets) {
            set.visitExternalArtifacts(visitor);
        }
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        for (ResolvedArtifactSet set : this.sets) {
            set.visitDependencies(context);
        }
    }

    private static class CompositeResult
    implements ResolvedArtifactSet.Completion {
        private final List<ResolvedArtifactSet.Completion> results;

        CompositeResult(List<ResolvedArtifactSet.Completion> results) {
            this.results = results;
        }

        @Override
        public void visit(ArtifactVisitor visitor) {
            for (ResolvedArtifactSet.Completion result : this.results) {
                result.visit(visitor);
            }
        }
    }
}

