/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf) / dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)) => dvec3(1.0lf, 1.0lf, 1.0lf)
 * (dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf) / dvec3(1.67lf, 0.66lf, 1.87lf)) => dvec3(-0.7984031936127745lf, -1.2878787878787878lf, -0.5026737967914437lf)
 * (dvec3(1.67lf, 0.66lf, 1.87lf) / dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)) => dvec3(-1.2525lf, -0.7764705882352941lf, -1.9893617021276597lf)
 * (dvec3(1.67lf, 0.66lf, 1.87lf) / dvec3(1.67lf, 0.66lf, 1.87lf)) => dvec3(1.0lf, 1.0lf, 1.0lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf) / dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)), dvec3(1.0lf, 1.0lf, 1.0lf)) <= 1.7320508075688774e-05lf ? 1 : -1] array0;
  double[distance((dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf) / dvec3(1.67lf, 0.66lf, 1.87lf)), dvec3(-0.7984031936127745lf, -1.2878787878787878lf, -0.5026737967914437lf)) <= 1.596483754323839e-05lf ? 1 : -1] array1;
  double[distance((dvec3(1.67lf, 0.66lf, 1.87lf) / dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)), dvec3(-1.2525lf, -0.7764705882352941lf, -1.9893617021276597lf)) <= 2.4757267228607288e-05lf ? 1 : -1] array2;
  double[distance((dvec3(1.67lf, 0.66lf, 1.87lf) / dvec3(1.67lf, 0.66lf, 1.87lf)), dvec3(1.0lf, 1.0lf, 1.0lf)) <= 1.7320508075688774e-05lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
