/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.desktopgui;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.i2p.I2PAppContext;
import net.i2p.desktopgui.Main;
import net.i2p.desktopgui.i18n.DesktopguiTranslator;
import net.i2p.util.SystemVersion;

abstract class TrayManager {
    protected final I2PAppContext _appContext;
    protected final Main _main;
    protected final boolean _useSwing;
    protected SystemTray tray;
    protected TrayIcon trayIcon;
    private static final String PNG_DIR = "/desktopgui/resources/images/";
    private static final String MAC_ICON = "itoopie_black_24.png";
    private static final String WIN_ICON = "itoopie_white_24.png";
    private static final String LIN_ICON = "logo.png";

    protected TrayManager(I2PAppContext ctx, Main main, boolean useSwing) {
        this._appContext = ctx;
        this._main = main;
        this._useSwing = useSwing;
    }

    public synchronized void startManager() throws AWTException {
        if (!SystemTray.isSupported()) {
            throw new AWTException("SystemTray not supported");
        }
        this.tray = SystemTray.getSystemTray();
        String tooltip = SystemVersion.isWindows() ? this._t("I2P: Right-click for menu") : null;
        TrayIcon ti = this._useSwing ? this.getSwingTrayIcon(tooltip) : this.getAWTTrayIcon(tooltip);
        ti.setImageAutoSize(true);
        this.tray.add(ti);
        this.trayIcon = ti;
    }

    private TrayIcon getAWTTrayIcon(String tooltip) throws AWTException {
        PopupMenu menu = this.getMainMenu();
        if (!SystemVersion.isWindows()) {
            menu.setFont(new Font("Arial", 1, 14));
        }
        TrayIcon ti = new TrayIcon(this.getTrayImage(), tooltip, menu);
        ti.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent m) {
            }

            @Override
            public void mouseEntered(MouseEvent m) {
            }

            @Override
            public void mouseExited(MouseEvent m) {
            }

            @Override
            public void mousePressed(MouseEvent m) {
                TrayManager.this.updateMenu();
            }

            @Override
            public void mouseReleased(MouseEvent m) {
                TrayManager.this.updateMenu();
            }
        });
        return ti;
    }

    private TrayIcon getSwingTrayIcon(String tooltip) throws AWTException {
        final JFrame frame = new JFrame();
        frame.setUndecorated(true);
        frame.setMinimumSize(new Dimension(0, 0));
        frame.setSize(0, 0);
        final JPopupMenu menu = this.getSwingMainMenu();
        menu.setFocusable(true);
        frame.add(menu);
        TrayIcon ti = new TrayIcon(this.getTrayImage(), tooltip, null);
        ti.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.handle(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.handle(e);
            }

            private void handle(MouseEvent e) {
                if (!frame.isVisible()) {
                    frame.setLocation(e.getX(), e.getY());
                    frame.setVisible(true);
                    menu.show(frame, 0, 0);
                }
                TrayManager.this.updateMenu();
            }
        });
        menu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                frame.setVisible(false);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
        menu.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                frame.setVisible(false);
            }
        });
        menu.addMenuKeyListener(new MenuKeyListener(){

            @Override
            public void menuKeyPressed(MenuKeyEvent e) {
            }

            @Override
            public void menuKeyReleased(MenuKeyEvent e) {
            }

            @Override
            public void menuKeyTyped(MenuKeyEvent e) {
                if (e.getKeyChar() == '\u001b') {
                    frame.setVisible(false);
                }
            }
        });
        return ti;
    }

    public synchronized void stopManager() {
        if (this.tray != null && this.trayIcon != null) {
            this.tray.remove(this.trayIcon);
            this.tray = null;
            this.trayIcon = null;
        }
    }

    public synchronized void languageChanged() {
        if (this.trayIcon != null && !this._useSwing) {
            this.trayIcon.setPopupMenu(this.getMainMenu());
        }
    }

    protected abstract PopupMenu getMainMenu();

    protected abstract JPopupMenu getSwingMainMenu();

    protected abstract void updateMenu();

    private Image getTrayImage() throws AWTException {
        String img = SystemVersion.isWindows() ? WIN_ICON : (SystemVersion.isMac() ? MAC_ICON : LIN_ICON);
        URL url = this.getClass().getResource(PNG_DIR + img);
        if (url == null) {
            throw new AWTException("cannot load tray image " + img);
        }
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        return image;
    }

    protected String _t(String s) {
        return DesktopguiTranslator._t(this._appContext, s);
    }

    protected String _t(String s, Object o) {
        return DesktopguiTranslator._t(this._appContext, s, o);
    }
}

