/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.util;

import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.util.CDQEntry;
import net.i2p.util.Log;

public class CoDelBlockingQueue<E extends CDQEntry>
extends LinkedBlockingQueue<E> {
    private static final long serialVersionUID = 1L;
    private final transient I2PAppContext _context;
    private final transient Log _log;
    private final String _name;
    private final int _capacity;
    private long _first_above_time;
    private long _drop_next;
    private int _count;
    private boolean _dropping;
    private long _now;
    private static final AtomicLong __id = new AtomicLong();
    private final long _id;
    private static final long TARGET = 15L;
    private static final long INTERVAL = 100L;
    private final String STAT_DROP;
    private final String STAT_DELAY;
    private static final long[] RATES = new long[]{300000L, 3600000L};
    private static final long BACKLOG_TIME = 2000L;

    public CoDelBlockingQueue(I2PAppContext ctx, String name, int capacity) {
        super(capacity);
        this._context = ctx;
        this._log = ctx.logManager().getLog(CoDelBlockingQueue.class);
        this._name = name;
        this._capacity = capacity;
        this.STAT_DROP = ("codel." + name + ".drop").intern();
        this.STAT_DELAY = ("codel." + name + ".delay").intern();
        ctx.statManager().createRateStat(this.STAT_DROP, "queue delay of dropped items", "Router", RATES);
        ctx.statManager().createRateStat(this.STAT_DELAY, "average queue delay", "Router", RATES);
        this._id = __id.incrementAndGet();
    }

    @Override
    public boolean add(E o) {
        o.setEnqueueTime(this._context.clock().now());
        return super.add(o);
    }

    @Override
    public boolean offer(E o) {
        o.setEnqueueTime(this._context.clock().now());
        return super.offer(o);
    }

    @Override
    public boolean offer(E o, long timeout, TimeUnit unit) throws InterruptedException {
        o.setEnqueueTime(this._context.clock().now());
        return super.offer(o, timeout, unit);
    }

    @Override
    public void put(E o) throws InterruptedException {
        o.setEnqueueTime(this._context.clock().now());
        super.put(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        super.clear();
        CoDelBlockingQueue coDelBlockingQueue = this;
        synchronized (coDelBlockingQueue) {
            this._first_above_time = 0L;
            this._drop_next = 0L;
            this._count = 0;
            this._dropping = false;
        }
    }

    @Override
    public E take() throws InterruptedException {
        E rv;
        while ((rv = this.deque()) == null) {
        }
        return rv;
    }

    @Override
    public E poll() {
        CDQEntry rv = (CDQEntry)super.poll();
        return (E)this.codel(rv);
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        Object e;
        int rv = 0;
        while ((e = this.poll()) != null) {
            c.add(e);
            ++rv;
        }
        return rv;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        Object e;
        int rv = 0;
        while ((e = this.poll()) != null && rv++ < maxElements) {
            c.add(e);
        }
        return rv;
    }

    public int drainAllTo(Collection<? super E> c) {
        return super.drainTo(c);
    }

    public boolean isBacklogged() {
        CDQEntry e = (CDQEntry)this.peek();
        if (e == null) {
            return false;
        }
        return this._dropping || this._context.clock().now() - e.getEnqueueTime() >= 2000L || this.remainingCapacity() < this._capacity / 4;
    }

    private boolean updateVars(E entry) {
        if (entry == null) {
            this._first_above_time = 0L;
            return false;
        }
        this._now = this._context.clock().now();
        boolean ok_to_drop = false;
        long sojurn = this._now - entry.getEnqueueTime();
        this._context.statManager().addRateData(this.STAT_DELAY, sojurn);
        if (sojurn < 15L || this.isEmpty()) {
            this._first_above_time = 0L;
        } else if (this._first_above_time == 0L) {
            this._first_above_time = this._now + 100L;
        } else if (this._now >= this._first_above_time) {
            ok_to_drop = true;
        }
        return ok_to_drop;
    }

    private E deque() throws InterruptedException {
        CDQEntry rv = (CDQEntry)super.take();
        return (E)this.codel(rv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E codel(E rv) {
        CoDelBlockingQueue coDelBlockingQueue = this;
        synchronized (coDelBlockingQueue) {
            boolean ok_to_drop = this.updateVars(rv);
            if (this._dropping) {
                if (!ok_to_drop) {
                    this._dropping = false;
                } else {
                    while (this._now >= this._drop_next && this._dropping) {
                        this.drop(rv);
                        ++this._count;
                        rv = (CDQEntry)super.poll();
                        ok_to_drop = this.updateVars(rv);
                        if (!ok_to_drop) {
                            this._dropping = false;
                            continue;
                        }
                        this.control_law(this._drop_next);
                    }
                }
            } else if (ok_to_drop && (this._now - this._drop_next < 100L || this._now - this._first_above_time >= 100L)) {
                this.drop(rv);
                rv = (CDQEntry)super.poll();
                this.updateVars(rv);
                this._dropping = true;
                this._count = this._now - this._drop_next < 100L ? (this._count > 2 ? this._count - 2 : 1) : 1;
                this.control_law(this._now);
            }
        }
        return rv;
    }

    private void drop(E entry) {
        long delay = this._context.clock().now() - entry.getEnqueueTime();
        this._context.statManager().addRateData(this.STAT_DROP, delay);
        if (this._log.shouldLog(30)) {
            this._log.warn("CDQ #" + this._id + ' ' + this._name + " dropped item with delay " + delay + ", " + DataHelper.formatDuration(this._context.clock().now() - this._first_above_time) + " since first above, " + DataHelper.formatDuration(this._context.clock().now() - this._drop_next) + " since drop next, " + (this._count + 1) + " dropped in this phase, " + this.size() + " remaining in queue: " + entry);
        }
        entry.drop();
    }

    private void control_law(long t) {
        this._drop_next = t + (long)(100.0 / Math.sqrt(this._count));
    }
}

