/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.Base64;
import net.i2p.data.SessionKey;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.transport.udp.EstablishmentManager;
import net.i2p.router.transport.udp.PacketBuilder;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.transport.udp.UDPPacketReader;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Addresses;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

class IntroductionManager {
    private final RouterContext _context;
    private final Log _log;
    private final UDPTransport _transport;
    private final PacketBuilder _builder;
    private final Map<Long, PeerState> _outbound;
    private final Set<PeerState> _inbound;
    private final Set<InetAddress> _recentHolePunches;
    private long _lastHolePunchClean;
    private static final int MAX_INBOUND = 20;
    public static final int MAX_OUTBOUND = 100;
    private static final long PUNCH_CLEAN_TIME = 5000L;
    private static final int MAX_PUNCHES = 8;
    private static final long INTRODUCER_EXPIRATION = 4800000L;

    public IntroductionManager(RouterContext ctx, UDPTransport transport) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(IntroductionManager.class);
        this._transport = transport;
        this._builder = new PacketBuilder(ctx, transport);
        this._outbound = new ConcurrentHashMap<Long, PeerState>(100);
        this._inbound = new ConcurrentHashSet<PeerState>(20);
        this._recentHolePunches = new HashSet<InetAddress>(16);
        ctx.statManager().createRateStat("udp.receiveRelayIntro", "How often we get a relayed request for us to talk to someone?", "udp", UDPTransport.RATES);
        ctx.statManager().createRateStat("udp.receiveRelayRequest", "How often we receive a good request to relay to someone else?", "udp", UDPTransport.RATES);
        ctx.statManager().createRateStat("udp.receiveRelayRequestBadTag", "Received relay requests with bad/expired tag", "udp", UDPTransport.RATES);
        ctx.statManager().createRateStat("udp.relayBadIP", "Received IP or port was bad", "udp", UDPTransport.RATES);
    }

    public void reset() {
        this._inbound.clear();
        this._outbound.clear();
    }

    public void add(PeerState peer) {
        if (peer == null) {
            return;
        }
        if (!TransportUtil.isValidPort(peer.getRemotePort())) {
            return;
        }
        if (peer.getRemoteIP().length != 4) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Adding peer " + peer.getRemoteHostId() + ", weRelayToThemAs " + peer.getWeRelayToThemAs() + ", theyRelayToUsAs " + peer.getTheyRelayToUsAs());
        }
        if (peer.getWeRelayToThemAs() > 0L) {
            this._outbound.put(peer.getWeRelayToThemAs(), peer);
        }
        if (peer.getTheyRelayToUsAs() > 0L && this._inbound.size() < 20) {
            this._inbound.add(peer);
        }
    }

    public void remove(PeerState peer) {
        long id;
        if (peer == null) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("removing peer " + peer.getRemoteHostId() + ", weRelayToThemAs " + peer.getWeRelayToThemAs() + ", theyRelayToUsAs " + peer.getTheyRelayToUsAs());
        }
        if ((id = peer.getWeRelayToThemAs()) > 0L) {
            this._outbound.remove(id);
        }
        if (peer.getTheyRelayToUsAs() > 0L) {
            this._inbound.remove(peer);
        }
    }

    private PeerState get(long id) {
        return this._outbound.get(id);
    }

    public int pickInbound(RouterAddress current, Properties ssuOptions, int howMany) {
        int start = this._context.random().nextInt();
        if (this._log.shouldLog(10)) {
            this._log.debug("Picking inbound out of " + this._inbound.size());
        }
        if (this._inbound.isEmpty()) {
            return 0;
        }
        ArrayList<PeerState> peers = new ArrayList<PeerState>(this._inbound);
        int sz = peers.size();
        start %= sz;
        int found = 0;
        long now = this._context.clock().now();
        long inactivityCutoff = now - 600000L;
        if (sz <= howMany + 2) {
            inactivityCutoff -= 300000L;
        }
        ArrayList<Introducer> introducers = new ArrayList<Introducer>(howMany);
        for (int i = 0; i < sz && found < howMany; ++i) {
            int port;
            PeerState cur = (PeerState)peers.get((start + i) % sz);
            RouterInfo ri = this._context.netDb().lookupRouterInfoLocally(cur.getRemotePeer());
            if (ri == null) {
                if (!this._log.shouldLog(20)) continue;
                this._log.info("Picked peer has no local routerInfo: " + cur);
                continue;
            }
            RouterAddress ra = this._transport.getTargetAddress(ri);
            if (ra == null) {
                if (!this._log.shouldLog(20)) continue;
                this._log.info("Picked peer has no SSU address: " + ri);
                continue;
            }
            if (this._context.banlist().isBanlisted(cur.getRemotePeer()) || this._transport.wasUnreachable(cur.getRemotePeer())) {
                if (!this._log.shouldLog(20)) continue;
                this._log.info("Peer is failing, blocklisted or was unreachable: " + cur);
                continue;
            }
            if (cur.getLastReceiveTime() < inactivityCutoff && cur.getLastSendTime() < inactivityCutoff) {
                if (!this._log.shouldLog(20)) continue;
                this._log.info("Peer is idle too long: " + cur);
                continue;
            }
            byte[] ip = cur.getRemoteIP();
            if (!this.isValid(ip, port = cur.getRemotePort())) continue;
            if (this._log.shouldLog(20)) {
                this._log.info("Picking introducer: " + cur);
            }
            cur.setIntroducerTime();
            UDPAddress ura = new UDPAddress(ra);
            byte[] ikey = ura.getIntroKey();
            if (ikey == null) continue;
            introducers.add(new Introducer(ip, port, ikey, cur.getTheyRelayToUsAs()));
            ++found;
        }
        Collections.sort(introducers);
        String exp = Long.toString((now + 4800000L) / 1000L);
        for (int i = 0; i < found; ++i) {
            Introducer in = (Introducer)introducers.get(i);
            ssuOptions.setProperty("ihost" + i, in.sip);
            ssuOptions.setProperty("iport" + i, in.sport);
            ssuOptions.setProperty("ikey" + i, in.skey);
            ssuOptions.setProperty("itag" + i, in.stag);
            String sexp = exp;
            if (current != null) {
                for (int j = 0; j < 3; ++j) {
                    if (!in.sip.equals(current.getOption("ihost" + j)) || !in.sport.equals(current.getOption("iport" + j)) || !in.skey.equals(current.getOption("ikey" + j)) || !in.stag.equals(current.getOption("itag" + j))) continue;
                    String oexp = current.getOption("iexp" + j);
                    if (oexp == null) break;
                    try {
                        long oex = Long.parseLong(oexp) * 1000L;
                        if (oex <= now + 1200000L) break;
                        sexp = oexp;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
            }
            ssuOptions.setProperty("iexp" + i, sexp);
        }
        this.pingIntroducers();
        return found;
    }

    public void pingIntroducers() {
        long now = this._context.clock().now();
        long pingCutoff = now - 6300000L;
        long inactivityCutoff = now - 165000L;
        for (PeerState cur : this._inbound) {
            if (cur.getIntroducerTime() <= pingCutoff || cur.getLastSendTime() >= inactivityCutoff) continue;
            if (this._log.shouldLog(20)) {
                this._log.info("Pinging introducer: " + cur);
            }
            cur.setLastSendTime(now);
            this._transport.send(this._builder.buildPing(cur));
        }
    }

    int introducerCount() {
        return this._inbound.size();
    }

    int introducedCount() {
        return this._outbound.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveRelayIntro(RemoteHostId bob, UDPPacketReader reader) {
        if (this._context.router().isHidden()) {
            return;
        }
        this._context.statManager().addRateData("udp.receiveRelayIntro", 1L);
        if (!this._transport.allowConnection()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Dropping RelayIntro, over conn limit");
            }
            return;
        }
        int ipSize = reader.getRelayIntroReader().readIPSize();
        byte[] ip = new byte[ipSize];
        reader.getRelayIntroReader().readIP(ip, 0);
        int port = reader.getRelayIntroReader().readPort();
        if (!this.isValid(ip, port) || !this.isValid(bob.getIP(), bob.getPort())) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Bad relay intro from " + bob + " for " + Addresses.toString(ip, port));
            }
            this._context.statManager().addRateData("udp.relayBadIP", 1L);
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Receive relay intro from " + bob + " for " + Addresses.toString(ip, port));
        }
        InetAddress to = null;
        try {
            to = InetAddress.getByAddress(ip);
        }
        catch (UnknownHostException uhe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("IP for alice to hole punch to is invalid", uhe);
            }
            this._context.statManager().addRateData("udp.relayBadIP", 1L);
            return;
        }
        RemoteHostId alice = new RemoteHostId(ip, port);
        if (this._transport.getPeerState(alice) != null) {
            if (this._log.shouldLog(20)) {
                this._log.info("Ignoring RelayIntro, already have a session to " + to);
            }
            return;
        }
        EstablishmentManager establisher = this._transport.getEstablisher();
        if (establisher != null) {
            if (establisher.getInboundState(alice) != null) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Ignoring RelayIntro, establishment in progress to " + to);
                }
                return;
            }
            if (!establisher.shouldAllowInboundEstablishment()) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Dropping RelayIntro, too many establishments in progress - for " + to);
                }
                return;
            }
        }
        boolean tooMany = false;
        boolean already = false;
        Set<InetAddress> set = this._recentHolePunches;
        synchronized (set) {
            long now = this._context.clock().now();
            if (now > this._lastHolePunchClean + 5000L) {
                this._recentHolePunches.clear();
                this._lastHolePunchClean = now;
                this._recentHolePunches.add(to);
            } else {
                boolean bl = tooMany = this._recentHolePunches.size() >= 8;
                if (!tooMany) {
                    already = !this._recentHolePunches.add(to);
                }
            }
        }
        if (tooMany) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Dropping - too many - RelayIntro for " + to);
            }
            return;
        }
        if (already) {
            if (this._log.shouldLog(20)) {
                this._log.info("Ignoring dup RelayIntro for " + to);
            }
            return;
        }
        this._transport.send(this._builder.buildHolePunch(to, port));
    }

    void receiveRelayRequest(RemoteHostId alice, UDPPacketReader reader) {
        if (this._context.router().isHidden()) {
            return;
        }
        UDPPacketReader.RelayRequestReader rrReader = reader.getRelayRequestReader();
        long tag = rrReader.readTag();
        int ipSize = rrReader.readIPSize();
        int port = rrReader.readPort();
        byte[] aliceIP = alice.getIP();
        int alicePort = alice.getPort();
        if (!this.isValid(alice.getIP(), alice.getPort())) {
            if (this._log.shouldWarn()) {
                this._log.warn("Bad relay req from " + alice + " for " + Addresses.toString(aliceIP, alicePort));
            }
            this._context.statManager().addRateData("udp.relayBadIP", 1L);
            return;
        }
        if (ipSize != 0) {
            byte[] ip = new byte[ipSize];
            rrReader.readIP(ip, 0);
            if (!Arrays.equals(aliceIP, ip)) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Bad relay req from " + alice + " for " + Addresses.toString(ip, port));
                }
                this._context.statManager().addRateData("udp.relayBadIP", 1L);
                return;
            }
        }
        if (port != 0 && port != alicePort) {
            if (this._log.shouldWarn()) {
                this._log.warn("Bad relay req from " + alice + " for " + Addresses.toString(aliceIP, port));
            }
            this._context.statManager().addRateData("udp.relayBadIP", 1L);
            return;
        }
        PeerState charlie = this.get(tag);
        if (charlie == null) {
            if (this._log.shouldLog(20)) {
                this._log.info("Receive relay request from " + alice + " with unknown tag");
            }
            this._context.statManager().addRateData("udp.receiveRelayRequestBadTag", 1L);
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Receive relay request from " + alice + " for tag " + tag + " and relaying with " + charlie);
        }
        this._context.statManager().addRateData("udp.receiveRelayRequest", 1L);
        this._transport.send(this._builder.buildRelayIntro(alice, charlie, reader.getRelayRequestReader()));
        SessionKey cipherKey = null;
        SessionKey macKey = null;
        PeerState aliceState = this._transport.getPeerState(alice);
        if (aliceState != null) {
            cipherKey = aliceState.getCurrentCipherKey();
            macKey = aliceState.getCurrentMACKey();
        }
        if (cipherKey == null || macKey == null) {
            byte[] key = new byte[32];
            reader.getRelayRequestReader().readAliceIntroKey(key, 0);
            macKey = cipherKey = new SessionKey(key);
            if (this._log.shouldLog(20)) {
                this._log.info("Sending relay response (w/ intro key) to " + alice);
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info("Sending relay response (in-session) to " + alice);
        }
        this._transport.send(this._builder.buildRelayResponse(alice, charlie, reader.getRelayRequestReader().readNonce(), cipherKey, macKey));
    }

    private boolean isValid(byte[] ip, int port) {
        return TransportUtil.isValidPort(port) && ip != null && ip.length == 4 && this._transport.isValid(ip) && !this._transport.isTooClose(ip) && !this._context.blocklist().isBlocklisted(ip);
    }

    private static class Introducer
    implements Comparable<Introducer> {
        public final String sip;
        public final String sport;
        public final String skey;
        public final String stag;

        public Introducer(byte[] ip, int port, byte[] key, long tag) {
            this.sip = Addresses.toString(ip);
            this.sport = String.valueOf(port);
            this.skey = Base64.encode(key);
            this.stag = String.valueOf(tag);
        }

        @Override
        public int compareTo(Introducer i) {
            return this.skey.compareTo(i.skey);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Introducer)) {
                return false;
            }
            Introducer i = (Introducer)o;
            return this.compareTo(i) == 0;
        }

        public int hashCode() {
            return this.skey.hashCode();
        }
    }
}

