/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.db;

import db.DBHandle;
import db.DBLongIterator;
import db.Field;
import db.IntField;
import db.Record;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.feature.fid.db.LibraryRecord;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.LanguageID;
import ghidra.util.UniversalIdGenerator;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LibrariesTable {
    static final String LIBRARIES_TABLE = "Libraries Table";
    static final int VERSION = 6;
    static final int LIBRARY_FAMILY_NAME_COL = 0;
    static final int LIBRARY_VERSION_COL = 1;
    static final int LIBRARY_VARIANT_COL = 2;
    static final int GHIDRA_VERSION_COL = 3;
    static final int GHIDRA_LANGUAGE_ID_COL = 4;
    static final int GHIDRA_LANGUAGE_VERSION_COL = 5;
    static final int GHIDRA_LANGUAGE_MINOR_VERSION_COL = 6;
    static final int GHIDRA_COMPILER_SPEC_ID_COL = 7;
    static final Schema SCHEMA = new Schema(6, "Library ID", new Class[]{StringField.class, StringField.class, StringField.class, StringField.class, StringField.class, IntField.class, IntField.class, StringField.class}, new String[]{"Library Family Name", "Library Version", "Library Variant", "Ghidra Version", "Ghidra Language ID", "Ghidra Language Version", "Ghidra Language Minor Version", "Ghidra Compiler Spec ID"});
    static int[] INDEXED_COLUMNS = new int[]{0, 1};
    Table table;

    public LibrariesTable(DBHandle handle) throws IOException, VersionException {
        this.table = handle.getTable(LIBRARIES_TABLE);
        this.checkVersion();
    }

    public static void createTable(DBHandle handle) throws IOException {
        handle.createTable(LIBRARIES_TABLE, SCHEMA, INDEXED_COLUMNS);
    }

    private void checkVersion() throws VersionException, IOException {
        int libraryVersion = this.table.getSchema().getVersion();
        if (libraryVersion != 6) {
            String msg = "Expected version 6 for table Libraries Table but got " + this.table.getSchema().getVersion();
            throw new VersionException(msg, libraryVersion < 6 ? 1 : 2, false);
        }
    }

    public Record createLibrary(String libraryFamilyName, String libraryVersion, String libraryVariant, String ghidraVersion, LanguageID languageID, int languageVersion, int languageMinorVersion, CompilerSpecID compilerSpecID) throws IOException {
        Record record = SCHEMA.createRecord(UniversalIdGenerator.nextID().getValue());
        record.setString(0, libraryFamilyName);
        record.setString(1, libraryVersion);
        record.setString(2, libraryVariant);
        record.setString(3, ghidraVersion);
        record.setString(4, languageID.getIdAsString());
        record.setIntValue(5, languageVersion);
        record.setIntValue(6, languageMinorVersion);
        record.setString(7, compilerSpecID.getIdAsString());
        this.table.putRecord(record);
        return record;
    }

    public List<LibraryRecord> getLibraries() throws IOException {
        RecordIterator iterator = this.table.iterator();
        if (!iterator.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<LibraryRecord> list = new ArrayList<LibraryRecord>();
        while (iterator.hasNext()) {
            list.add(new LibraryRecord(iterator.next()));
        }
        return list;
    }

    public List<LibraryRecord> getLibrariesByName(String name, String version, String variant) throws IOException {
        StringField hashField = new StringField(name);
        DBLongIterator iterator = this.table.indexKeyIterator(0, (Field)hashField, (Field)hashField, true);
        if (!iterator.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<LibraryRecord> list = new ArrayList<LibraryRecord>();
        while (iterator.hasNext()) {
            long key = iterator.next();
            Record record = this.table.getRecord(key);
            LibraryRecord libraryRecord = new LibraryRecord(record);
            if (version != null && !libraryRecord.getLibraryVersion().equals(version) || variant != null && !libraryRecord.getLibraryVariant().equals(variant)) continue;
            list.add(libraryRecord);
        }
        return list;
    }

    public Record getLibraryByID(long id) throws IOException {
        Record record = this.table.getRecord(id);
        return record;
    }
}

