/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.coff;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.coff.archive.CoffArchiveConstants;
import ghidra.file.formats.coff.CoffArchiveFileSystem;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryFull;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeBytesOnly;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import utilities.util.ArrayUtilities;

public class CoffArchiveFileSystemFactory
implements GFileSystemFactoryFull<CoffArchiveFileSystem>,
GFileSystemProbeBytesOnly {
    public static final int PROBE_BYTES_REQUIRED = 8;

    public CoffArchiveFileSystem create(FSRL containerFSRL, FSRLRoot targetFSRL, ByteProvider byteProvider, File containerFile, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        CoffArchiveFileSystem fs = new CoffArchiveFileSystem(targetFSRL, byteProvider);
        fs.mount(monitor);
        return fs;
    }

    public int getBytesRequired() {
        return 8;
    }

    public boolean probeStartBytes(FSRL containerFSRL, byte[] startBytes) {
        return ArrayUtilities.arrayRangesEquals((byte[])CoffArchiveConstants.MAGIC_BYTES, (int)0, (byte[])startBytes, (int)0, (int)CoffArchiveConstants.MAGIC_BYTES.length);
    }
}

