/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.crypto;

import generic.jar.ResourceFile;
import ghidra.file.crypto.CryptoKey;
import ghidra.framework.Application;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.CryptoException;
import ghidra.util.xml.XmlUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import util.CollectionUtils;

public final class CryptoKeyFactory {
    private static Map<String, Map<String, CryptoKey>> cryptoMap = new HashMap<String, Map<String, CryptoKey>>();
    private static Map<String, Long> fileDatesMap = new HashMap<String, Long>();

    public static void forceReload() {
        cryptoMap.clear();
        fileDatesMap.clear();
        CryptoKeyFactory.loadIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadIfNeeded() {
        ResourceFile[] files;
        ResourceFile cryptoDirectory = CryptoKeyFactory.getCryptoDirectory();
        for (ResourceFile file : files = cryptoDirectory.listFiles()) {
            if (!file.getName().endsWith(".xml") || fileDatesMap.containsKey(file.getName()) && fileDatesMap.get(file.getName()).longValue() == file.lastModified()) continue;
            fileDatesMap.put(file.getName(), file.lastModified());
            try (InputStream is = file.getInputStream();){
                SAXBuilder sax = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
                Document doc = sax.build(is);
                Element root = doc.getRootElement();
                String firmwareName = root.getAttributeValue("NAME");
                if (!cryptoMap.containsKey(firmwareName)) {
                    cryptoMap.put(firmwareName, new HashMap());
                }
                List firmwareFileList = CollectionUtils.asList((List)root.getChildren(), Element.class);
                for (Element firmwareFileElement : firmwareFileList) {
                    String path = firmwareFileElement.getAttributeValue("PATH");
                    if (firmwareFileElement.getAttribute("not_encrypted") != null) {
                        cryptoMap.get(firmwareName).put(path, CryptoKey.NOT_ENCRYPTED_KEY);
                        continue;
                    }
                    Element keyElement = firmwareFileElement.getChild("KEY");
                    String keyString = keyElement.getText().trim();
                    if (keyString.length() % 2 != 0) {
                        throw new CryptoException("Invalid key length in [" + firmwareName + ".xml] for [" + path + "]");
                    }
                    byte[] key = NumericUtilities.convertStringToBytes((String)keyString);
                    Element ivElement = firmwareFileElement.getChild("IV");
                    String ivString = ivElement.getText().trim();
                    if (ivString.length() % 2 != 0) {
                        throw new CryptoException("Invalid iv length in [" + firmwareName + ".xml] for [" + path + "]");
                    }
                    byte[] iv = NumericUtilities.convertStringToBytes((String)ivString);
                    CryptoKey cryptoKey = new CryptoKey(key, iv);
                    cryptoMap.get(firmwareName).put(path, cryptoKey);
                }
            }
            catch (Exception e) {
                Msg.showWarn(CryptoKeyFactory.class, null, (String)"Error Parsing Crypto Keys File", (Object)"Unable to process crypto keys files.", (Throwable)e);
            }
        }
    }

    public static ResourceFile getCryptoDirectory() {
        try {
            return Application.getModuleDataSubDirectory((String)"crypto");
        }
        catch (IOException iOException) {
            throw new RuntimeException("cannot find crypto directory");
        }
    }

    public static CryptoKey getCryptoKey(String firmwareName, String firmwarePath) throws CryptoException {
        CryptoKeyFactory.loadIfNeeded();
        Map<String, CryptoKey> firmwareMap = cryptoMap.get(firmwareName);
        if (firmwareMap == null) {
            throw new CryptoException("Firmware may be encrypted, but XML key file does not exist: [" + firmwareName + ".xml]");
        }
        CryptoKey cryptoKey = firmwareMap.get(firmwarePath);
        if (cryptoKey == null) {
            File file = new File(firmwarePath);
            cryptoKey = firmwareMap.get(file.getName());
        }
        if (cryptoKey == null) {
            throw new CryptoException("[" + firmwareName + ".xml] does not contain an entry for " + firmwarePath + ".  File might be encrypted.");
        }
        if (cryptoKey == CryptoKey.NOT_ENCRYPTED_KEY) {
            return cryptoKey;
        }
        if (cryptoKey.isEmpty()) {
            throw new CryptoException("No key specified in [" + firmwareName + ".xml] file for [" + firmwarePath + "]");
        }
        return cryptoKey;
    }
}

