/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.provider.markuptable.MarkupStatusIcons;
import ghidra.feature.vt.gui.task.ApplyMarkupItemTask;
import ghidra.feature.vt.gui.task.ForceApplyMarkupItemTask;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.util.HelpLocation;
import ghidra.util.task.Task;
import ghidra.util.task.TaskListener;
import java.util.List;

public class ApplyUsingOptionsAndForcingMarkupItemAction
extends DockingAction {
    private static final String MENU_GROUP = "A_VT_Apply_Edit";
    private final VTController controller;

    public ApplyUsingOptionsAndForcingMarkupItemAction(VTController controller, boolean addToToolbar) {
        super("Apply Markup Using Options And Forcing", VTPlugin.OWNER);
        this.controller = controller;
        if (addToToolbar) {
            this.setToolBarData(new ToolBarData(MarkupStatusIcons.APPLIED_ICON, "A_VT_Edit_1"));
        }
        MenuData menuData = new MenuData(new String[]{"Apply (Use Options; Force If Necessary)"}, MarkupStatusIcons.APPLIED_ICON, MENU_GROUP);
        menuData.setMenuSubGroup("0");
        this.setPopupMenuData(menuData);
        this.setEnabled(false);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Apply_Markup_Item_Using_Options_And_Forcing"));
    }

    protected ApplyMarkupItemTask createApplyTask(VTSession session, List<VTMarkupItem> markupItems, ToolOptions options) {
        return new ForceApplyMarkupItemTask(session, markupItems, options);
    }

    public void actionPerformed(ActionContext context) {
        List<VTMarkupItem> markupItems = this.controller.getMarkupItems(context);
        ToolOptions options = this.controller.getOptions();
        ApplyMarkupItemTask task = this.createApplyTask(this.controller.getSession(), markupItems, options);
        task.addTaskListener(new TaskListener(){

            public void taskCompleted(Task t) {
                ApplyUsingOptionsAndForcingMarkupItemAction.this.controller.refresh();
            }

            public void taskCancelled(Task t) {
            }
        });
        this.controller.runVTTask(task);
    }

    public boolean isEnabledForContext(ActionContext context) {
        List<VTMarkupItem> markupItems = this.controller.getMarkupItems(context);
        if (markupItems.size() == 0) {
            return false;
        }
        for (VTMarkupItem markupItem : markupItems) {
            if (!markupItem.canApply()) {
                return false;
            }
            Address address = markupItem.getDestinationAddress();
            if (address != null && address != Address.NO_ADDRESS) continue;
            return false;
        }
        return true;
    }

    public boolean isAddToPopup(ActionContext context) {
        List<VTMarkupItem> markupItems = this.controller.getMarkupItems(context);
        if (markupItems.size() == 0) {
            return false;
        }
        for (VTMarkupItem markupItem : markupItems) {
            if (markupItem.canApply()) continue;
            return false;
        }
        return true;
    }
}

