/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.jml;

import [Ljava.lang.Object;;
import com.jeta.forms.store.JETAPersistable;
import com.jeta.forms.store.jml.ColorHolderSerializer;
import com.jeta.forms.store.jml.HashMapSerializer;
import com.jeta.forms.store.jml.InsetsSerializer;
import com.jeta.forms.store.jml.JMLObjectOutput;
import com.jeta.forms.store.jml.JMLSerializer;
import com.jeta.forms.store.jml.ListSerializer;
import com.jeta.forms.store.jml.NullSerializer;
import com.jeta.forms.store.jml.ObjectArraySerializer;
import com.jeta.forms.store.jml.PrimitiveHolder;
import com.jeta.forms.store.jml.PrimitiveSerializer;
import com.jeta.forms.store.jml.PropertyMapSerializer;
import com.jeta.forms.store.jml.StringSerializer;
import com.jeta.forms.store.properties.ColorHolder;
import com.jeta.forms.store.support.PropertyMap;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public class JMLSerializerFactory {
    public static final String COMPONENT_ID;
    private HashMap m_serializers = new HashMap();
    private JMLSerializer m_persistable_serializer = new JMLObjectOutput.XMLObjectOutputSerializer();
    private JMLSerializer m_null_serializer = new NullSerializer();
    static final /* synthetic */ boolean $assertionsDisabled;

    private JMLSerializerFactory() {
        this.initialize();
    }

    public static JMLSerializerFactory getInstance() {
        return new JMLSerializerFactory();
    }

    private void registerSerializer(Class clazz, JMLSerializer jMLSerializer) {
        this.m_serializers.put(clazz, jMLSerializer);
    }

    private void initialize() {
        this.registerSerializer(PropertyMap.class, new PropertyMapSerializer());
        this.registerSerializer(HashMap.class, new HashMapSerializer());
        this.registerSerializer(LinkedList.class, new ListSerializer(LinkedList.class));
        this.registerSerializer(ArrayList.class, new ListSerializer(ArrayList.class));
        this.registerSerializer(Boolean.class, new PrimitiveSerializer());
        this.registerSerializer(Byte.class, new PrimitiveSerializer());
        this.registerSerializer(Character.class, new PrimitiveSerializer());
        this.registerSerializer(Short.class, new PrimitiveSerializer());
        this.registerSerializer(Integer.class, new PrimitiveSerializer());
        this.registerSerializer(Long.class, new PrimitiveSerializer());
        this.registerSerializer(Float.class, new PrimitiveSerializer());
        this.registerSerializer(Double.class, new PrimitiveSerializer());
        this.registerSerializer(String.class, new StringSerializer());
        this.registerSerializer(Insets.class, new InsetsSerializer());
        this.registerSerializer(ColorHolder.class, new ColorHolderSerializer());
        this.registerSerializer(Object;.class, new ObjectArraySerializer());
        this.registerSerializer(PrimitiveHolder.class, new PrimitiveSerializer());
    }

    public JMLSerializer createSerializer(Object object) {
        JMLSerializer jMLSerializer = null;
        if (object == null) {
            jMLSerializer = this.m_null_serializer;
        } else {
            jMLSerializer = (JMLSerializer)this.m_serializers.get(object.getClass());
            if (jMLSerializer == null && object instanceof JETAPersistable) {
                jMLSerializer = this.m_persistable_serializer;
            }
        }
        if (jMLSerializer == null) {
            System.out.println("JMLSerializerFactory.createSerializer failed: " + object.getClass());
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        return jMLSerializer;
    }

    static {
        $assertionsDisabled = !JMLSerializerFactory.class.desiredAssertionStatus();
        COMPONENT_ID = null;
    }
}

