/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.effects;

import com.jeta.forms.gui.effects.Painter;
import com.jeta.forms.store.properties.effects.TextureProperty;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;

public class TexturePainter
implements Painter {
    private TextureProperty m_texture_prop;
    private Paint m_cached_paint;
    private Rectangle m_last_rect;

    public TexturePainter() {
    }

    public TexturePainter(TextureProperty textureProperty) {
        this.m_texture_prop = textureProperty;
    }

    private Paint createPaint(Rectangle rectangle, TextureProperty textureProperty) {
        BufferedImage bufferedImage = textureProperty.getBufferedImage();
        rectangle = new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        return new TexturePaint(bufferedImage, rectangle);
    }

    public void paint(Component component, Graphics graphics, Rectangle rectangle) {
        if (rectangle == null || this.m_texture_prop == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        if (this.m_cached_paint == null || !rectangle.equals(this.m_last_rect)) {
            this.m_last_rect = rectangle;
            this.m_cached_paint = this.createPaint(rectangle, this.m_texture_prop);
        }
        graphics2D.setPaint(this.m_cached_paint);
        graphics2D.translate(rectangle.x, rectangle.y);
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics2D.translate(-rectangle.x, -rectangle.y);
        graphics2D.setPaint(paint);
    }

    public void setTextureProperty(TextureProperty textureProperty) {
        this.m_cached_paint = null;
        this.m_texture_prop = textureProperty;
    }
}

