/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.block.BasicBlockModel;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.listing.Function;
import ghidra.program.model.symbol.FlowType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class CyclomaticComplexity {
    public int calculateCyclomaticComplexity(Function function, TaskMonitor monitor) throws CancelledException {
        BasicBlockModel basicBlockModel = new BasicBlockModel(function.getProgram());
        CodeBlockIterator codeBlockIterator = basicBlockModel.getCodeBlocksContaining(function.getBody(), monitor);
        Address entryPoint = function.getEntryPoint();
        int nodes = 0;
        int edges = 0;
        int exits = 0;
        while (codeBlockIterator.hasNext() && !monitor.isCancelled()) {
            CodeBlock codeBlock = codeBlockIterator.next();
            ++nodes;
            if (codeBlock.getFlowType().isTerminal()) {
                ++exits;
                ++edges;
            }
            CodeBlockReferenceIterator destinations = codeBlock.getDestinations(monitor);
            while (destinations.hasNext() && !monitor.isCancelled()) {
                CodeBlockReference reference = destinations.next();
                FlowType flowType = reference.getFlowType();
                if (flowType.isIndirect() || flowType.isCall()) continue;
                ++edges;
                if (!codeBlock.getFlowType().isTerminal() || !reference.getDestinationAddress().equals(entryPoint)) continue;
                --edges;
            }
        }
        int complexity = edges - nodes + exits;
        return complexity < 0 ? 0 : complexity;
    }
}

