/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.SignedDWordDataType;

public class DWordDataType
extends AbstractIntegerDataType {
    private static final long serialVersionUID = 1L;
    public static final DWordDataType dataType = new DWordDataType();

    public DWordDataType() {
        this(null);
    }

    public DWordDataType(DataTypeManager dtm) {
        super("dword", false, dtm);
    }

    @Override
    public String getDescription() {
        return "Unsigned Double-Word (ddw, 4-bytes)";
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public String getAssemblyMnemonic() {
        return "ddw";
    }

    @Override
    public SignedDWordDataType getOppositeSignednessDataType() {
        return SignedDWordDataType.dataType.clone(this.getDataTypeManager());
    }

    @Override
    public DWordDataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new DWordDataType(dtm);
    }
}

