/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.map;

import db.DBLongIterator;
import db.util.ErrorHandler;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class AddressKeyAddressIterator
implements AddressIterator {
    private DBLongIterator keyIter;
    private AddressMap addrMap;
    private ErrorHandler errHandler;
    private boolean forward;

    public AddressKeyAddressIterator(DBLongIterator keyIter, boolean forward, AddressMap addrMap, ErrorHandler errHandler) {
        this.keyIter = keyIter;
        this.addrMap = addrMap;
        this.forward = forward;
        this.errHandler = errHandler;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.keyIter != null && (this.forward ? this.keyIter.hasNext() : this.keyIter.hasPrevious());
        }
        catch (IOException e) {
            if (this.errHandler != null) {
                this.errHandler.dbError(e);
            }
            return false;
        }
    }

    @Override
    public Address next() {
        Address addr;
        block4: {
            if (this.keyIter == null) {
                return null;
            }
            addr = null;
            try {
                addr = this.addrMap.decodeAddress(this.forward ? this.keyIter.next() : this.keyIter.previous());
            }
            catch (NoSuchElementException e) {
                return null;
            }
            catch (IOException e) {
                if (this.errHandler == null) break block4;
                this.errHandler.dbError(e);
            }
        }
        return addr;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Address> iterator() {
        return this;
    }
}

