/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import db.DBHandle;
import db.Record;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.code.CommentsDBAdapter;
import ghidra.program.database.map.AddressKeyIterator;
import ghidra.program.database.map.AddressKeyRecordIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.map.AddressRecordDeleter;
import ghidra.program.database.util.DatabaseTableUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

class CommentsDBAdapterV1
extends CommentsDBAdapter {
    private Table commentTable;
    private AddressMap addrMap;

    CommentsDBAdapterV1(DBHandle handle, AddressMap addrMap, boolean create) throws IOException, VersionException {
        this.addrMap = addrMap;
        if (create) {
            this.commentTable = handle.createTable("Comments", COMMENTS_SCHEMA);
        } else {
            this.commentTable = handle.getTable("Comments");
            if (this.commentTable == null) {
                throw new VersionException("Missing Table: Comments");
            }
            if (this.commentTable.getSchema().getVersion() != 1) {
                int version = this.commentTable.getSchema().getVersion();
                if (version < 1) {
                    throw new VersionException(true);
                }
                throw new VersionException(2, false);
            }
        }
    }

    @Override
    Record getRecord(long addr) throws IOException {
        return this.commentTable.getRecord(addr);
    }

    @Override
    Record createRecord(long addr, int commentCol, String comment) throws IOException {
        Record record = COMMENTS_SCHEMA.createRecord(addr);
        record.setString(commentCol, comment);
        this.commentTable.putRecord(record);
        return record;
    }

    @Override
    boolean deleteRecord(long addr) throws IOException {
        return this.commentTable.deleteRecord(addr);
    }

    @Override
    boolean deleteRecords(Address start, Address end) throws IOException {
        return AddressRecordDeleter.deleteRecords(this.commentTable, this.addrMap, start, end);
    }

    @Override
    void updateRecord(Record commentRec) throws IOException {
        this.commentTable.putRecord(commentRec);
    }

    @Override
    AddressKeyIterator getKeys(Address start, Address end, boolean atStart) throws IOException {
        if (atStart) {
            return new AddressKeyIterator(this.commentTable, this.addrMap, start, end, start, true);
        }
        return new AddressKeyIterator(this.commentTable, this.addrMap, start, end, end, false);
    }

    @Override
    AddressKeyIterator getKeys(AddressSetView set, boolean forward) throws IOException {
        if (forward) {
            return new AddressKeyIterator(this.commentTable, this.addrMap, set, set.getMinAddress(), true);
        }
        return new AddressKeyIterator(this.commentTable, this.addrMap, set, set.getMaxAddress(), false);
    }

    @Override
    RecordIterator getRecords(Address start, Address end, boolean atStart) throws IOException {
        if (atStart) {
            return new AddressKeyRecordIterator(this.commentTable, this.addrMap, start, end, start, true);
        }
        return new AddressKeyRecordIterator(this.commentTable, this.addrMap, start, end, end, false);
    }

    @Override
    RecordIterator getRecords(Address addr) throws IOException {
        return new AddressKeyRecordIterator(this.commentTable, this.addrMap, addr, true);
    }

    @Override
    RecordIterator getRecords() throws IOException {
        return new AddressKeyRecordIterator(this.commentTable, this.addrMap);
    }

    @Override
    void putRecord(Record record) throws IOException {
        this.commentTable.putRecord(record);
    }

    @Override
    int getRecordCount() throws IOException {
        return this.commentTable.getRecordCount();
    }

    @Override
    void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException, IOException {
        DatabaseTableUtils.updateAddressKey(this.commentTable, this.addrMap, fromAddr, toAddr, length, monitor);
    }
}

