/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emulate.callother;

import ghidra.pcode.emulate.Emulate;
import ghidra.pcode.emulate.callother.OpBehaviorOther;
import ghidra.pcode.memstate.MemoryState;
import ghidra.pcodeCPort.error.LowlevelError;
import ghidra.program.model.pcode.Varnode;

public class CountLeadingOnesOpBehavior
implements OpBehaviorOther {
    @Override
    public void evaluate(Emulate emu, Varnode out, Varnode[] inputs) {
        if (out == null) {
            throw new LowlevelError("CALLOTHER: Count Leading Ones op missing required output");
        }
        if (inputs.length != 2 || inputs[1].getSize() == 0 || inputs[1].isConstant()) {
            throw new LowlevelError("CALLOTHER: Count Leading Ones op requires one non-constant varnode input");
        }
        Varnode in = inputs[1];
        if (in.getSize() > 8 || out.getSize() > 8) {
            throw new LowlevelError("CALLOTHER: Count Leading Ones op only supports varnodes of size 8-bytes or less");
        }
        MemoryState memoryState = emu.getMemoryState();
        long value = memoryState.getValue(in);
        long mask = 1L << in.getSize() * 8 - 1;
        long count = 0L;
        while ((mask & value) != 0L) {
            ++count;
            value <<= 1;
        }
        memoryState.setValue(out, count);
    }
}

