/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfsplus;

import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.Util;

public class HFSCatalogNodeID
implements StructElements {
    public static final HFSCatalogNodeID kHFSRootParentID = new HFSCatalogNodeID(1);
    public static final HFSCatalogNodeID kHFSRootFolderID = new HFSCatalogNodeID(2);
    public static final HFSCatalogNodeID kHFSExtentsFileID = new HFSCatalogNodeID(3);
    public static final HFSCatalogNodeID kHFSCatalogFileID = new HFSCatalogNodeID(4);
    public static final HFSCatalogNodeID kHFSBadBlockFileID = new HFSCatalogNodeID(5);
    public static final HFSCatalogNodeID kHFSAllocationFileID = new HFSCatalogNodeID(6);
    public static final HFSCatalogNodeID kHFSStartupFileID = new HFSCatalogNodeID(7);
    public static final HFSCatalogNodeID kHFSAttributesFileID = new HFSCatalogNodeID(8);
    public static final HFSCatalogNodeID kHFSRepairCatalogFileID = new HFSCatalogNodeID(14);
    public static final HFSCatalogNodeID kHFSBogusExtentFileID = new HFSCatalogNodeID(15);
    public static final HFSCatalogNodeID kHFSFirstUserCatalogNodeID = new HFSCatalogNodeID(16);
    private final byte[] hfsCatalogNodeID = new byte[4];

    public HFSCatalogNodeID(byte[] data, int offset) {
        System.arraycopy(data, offset, this.hfsCatalogNodeID, 0, 4);
    }

    public HFSCatalogNodeID(int nodeID) {
        System.arraycopy(Util.toByteArrayBE((int)nodeID), 0, this.hfsCatalogNodeID, 0, 4);
    }

    public static int length() {
        return 4;
    }

    public int toInt() {
        return Util.readIntBE((byte[])this.hfsCatalogNodeID);
    }

    public long toLong() {
        return Util.unsign((int)this.toInt());
    }

    public String getDescription() {
        String result;
        switch (this.toInt()) {
            case 1: {
                result = "kHFSRootParentID";
                break;
            }
            case 2: {
                result = "kHFSRootFolderID";
                break;
            }
            case 3: {
                result = "kHFSExtentsFileID";
                break;
            }
            case 4: {
                result = "kHFSCatalogFileID";
                break;
            }
            case 5: {
                result = "kHFSBadBlockFileID";
                break;
            }
            case 6: {
                result = "kHFSAllocationFileID";
                break;
            }
            case 7: {
                result = "kHFSStartupFileID";
                break;
            }
            case 8: {
                result = "kHFSAttributesFileID";
                break;
            }
            case 14: {
                result = "kHFSRepairCatalogFileID";
                break;
            }
            case 15: {
                result = "kHFSBogusExtentFileID";
                break;
            }
            case 16: {
                result = "kHFSFirstUserCatalogNodeID";
                break;
            }
            default: {
                result = "User Defined ID";
            }
        }
        return result;
    }

    public String toString() {
        return "" + Util.unsign((int)this.toInt());
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " hfsCatalogNodeID: " + this.toString() + " (" + this.getDescription() + ")");
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "HFSCatalogNodeID:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        return Util.createCopy((byte[])this.hfsCatalogNodeID);
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(HFSCatalogNodeID.class.getSimpleName());
        db.addUIntBE("hfsCatalogNodeID", this.hfsCatalogNodeID);
        return db.getResult();
    }
}

