/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.options;

import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.options.ScreenElement;
import ghidra.framework.options.EditorStateFactory;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsEditor;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;

public class ListingDisplayOptionsEditor
implements OptionsEditor {
    public static final Font DEFAULT_FONT = new Font("Monospaced", 0, 12);
    private OptionsGui optionsGui;
    private Options options;
    private PropertyChangeListener propertyChangeListener;

    public ListingDisplayOptionsEditor(Options options) {
        this.options = options;
        this.registerOptions();
    }

    public void dispose() {
        if (this.optionsGui != null) {
            this.optionsGui.setOptionsPropertyChangeListener(null);
        }
        this.propertyChangeListener = null;
    }

    private void registerOptions() {
        String prefix = "Sets the ";
        this.options.registerOption("BASE FONT", (Object)DEFAULT_FONT, null, prefix + "BASE FONT");
        for (ScreenElement element : OptionsGui.elements) {
            String colorOptionName = element.getColorOptionName();
            this.options.registerOption(colorOptionName, (Object)element.getDefaultColor(), null, prefix + colorOptionName);
            String styleOptionName = element.getStyleOptionName();
            this.options.registerOption(styleOptionName, (Object)-1, null, prefix + styleOptionName);
        }
    }

    public void apply() {
        if (this.optionsGui != null) {
            Font font = this.options.getFont("BASE FONT", DEFAULT_FONT);
            Font newFont = this.optionsGui.getBaseFont();
            if (!newFont.equals(font)) {
                this.options.setFont("BASE FONT", newFont);
            }
            for (ScreenElement element : OptionsGui.elements) {
                int guiStyle;
                int optionStyle;
                Color guiColor = element.getColor();
                Color optionColor = this.options.getColor(element.getColorOptionName(), element.getDefaultColor());
                if (!optionColor.equals(guiColor)) {
                    this.options.setColor(element.getColorOptionName(), guiColor);
                }
                if ((optionStyle = this.options.getInt(element.getStyleOptionName(), -1)) == (guiStyle = element.getStyle())) continue;
                this.options.setInt(element.getStyleOptionName(), guiStyle);
            }
        }
    }

    public void cancel() {
    }

    public void reload() {
    }

    public void setOptionsPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListener = listener;
        if (this.optionsGui != null) {
            this.optionsGui.setOptionsPropertyChangeListener(listener);
        }
    }

    public boolean isResizable() {
        return true;
    }

    public JComponent getEditorComponent(Options editableOptions, EditorStateFactory editorStateFactory) {
        Font font = this.options.getFont("BASE FONT", DEFAULT_FONT);
        for (ScreenElement element : OptionsGui.elements) {
            Color c = this.options.getColor(element.getColorOptionName(), element.getDefaultColor());
            int style = this.options.getInt(element.getStyleOptionName(), -1);
            element.setColor(c);
            element.setStyle(style);
        }
        this.optionsGui = new OptionsGui(font, this.propertyChangeListener);
        return this.optionsGui;
    }
}

