/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class GnuVerneed
implements StructConverter {
    private short vn_version;
    private short vn_cnt;
    private int vn_file;
    private int vn_aux;
    private int vn_next;

    GnuVerneed(BinaryReader reader) throws IOException {
        this.vn_version = reader.readNextShort();
        this.vn_cnt = reader.readNextShort();
        this.vn_file = reader.readNextInt();
        this.vn_aux = reader.readNextInt();
        this.vn_next = reader.readNextInt();
    }

    public short getVersion() {
        return this.vn_version;
    }

    public short getCnt() {
        return this.vn_cnt;
    }

    public int getFile() {
        return this.vn_file;
    }

    public int getAux() {
        return this.vn_aux;
    }

    public int getNext() {
        return this.vn_next;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("Elf_Verneed", 0);
        struct.add(WORD, "vd_version", "Version of structure");
        struct.add(WORD, "vd_cnt", "Number of associated aux entries");
        struct.add(DWORD, "vn_file", "Offset of filename for this dependency");
        struct.add(DWORD, "vd_aux", "Offset in bytes to vernaux array");
        struct.add(DWORD, "vd_next", "Offset in bytes to next verneed entry");
        return struct;
    }
}

