/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symtable;

import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.label.GHtmlLabel;
import docking.widgets.label.GIconLabel;
import ghidra.app.plugin.core.symtable.NewSymbolFilter;
import ghidra.app.plugin.core.symtable.SymbolTableModel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.MessageType;
import ghidra.util.layout.HorizontalLayout;
import ghidra.util.layout.MiddleLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import resources.ResourceManager;

public class FilterDialog
extends DialogComponentProvider {
    private NewSymbolFilter filter;
    private JPanel advancedPanel;
    private JPanel advancedFilterPanel;
    private Map<String, JCheckBox> checkBoxMap = new HashMap<String, JCheckBox>();
    private boolean ignoreCallbacks;
    private JCheckBox advancedFilterCheckbox;
    private SymbolTableModel keyModel;
    private boolean isChanged;
    private FilterCheckboxItemListener checkboxListener = new FilterCheckboxItemListener();
    private PluginTool tool;

    public FilterDialog(PluginTool tool) {
        super("Symbol Table Filter", false);
        this.tool = tool;
        this.filter = new NewSymbolFilter();
        this.addWorkPanel(this.buildWorkPanel());
        this.addOKButton();
        this.addApplyButton();
        this.addDismissButton();
        this.setHelpLocation(new HelpLocation("SymbolTablePlugin", "Set Filter"));
        this.initCheckBoxes();
        this.setRememberSize(false);
    }

    public void setStatusText(String text) {
        super.setStatusText(text, MessageType.ALERT);
    }

    void setFilter(NewSymbolFilter newFilter) {
        this.filter = new NewSymbolFilter(newFilter);
        this.initCheckBoxes();
        this.setChanged(true);
    }

    Element saveFilter() {
        return this.filter.saveToXml();
    }

    void restoreFilter(Element element) {
        this.filter.restoreFromXml(element);
        this.initCheckBoxes();
    }

    private void initCheckBoxes() {
        this.setChanged(false);
        this.ignoreCallbacks = true;
        for (String filterName : this.checkBoxMap.keySet()) {
            JCheckBox cb = this.checkBoxMap.get(filterName);
            cb.setSelected(this.filter.isActive(filterName));
        }
        this.ignoreCallbacks = false;
        this.advancedFilterCheckbox.setSelected(this.filter.getActiveAdvancedFilterCount() > 0);
        this.update();
    }

    private JComponent buildWorkPanel() {
        this.advancedFilterCheckbox = new GCheckBox("Use Advanced Filters");
        this.advancedFilterCheckbox.setToolTipText(HTMLUtilities.toHTML((String)"Show advance filters.  Advanced filters eliminate all appropriate\nsymbols that don't match the filter.  Selecting mutually exclusive filters\n(such as Globals and Locals) will totally eliminate entire types of symbols."));
        this.advancedFilterCheckbox.addItemListener(e -> {
            this.setStatusText("");
            JCheckBox cb = (JCheckBox)e.getSource();
            if (cb.isSelected()) {
                this.advancedPanel.add(this.advancedFilterPanel);
            } else {
                this.advancedPanel.removeAll();
                this.clearAdvancedFilters();
            }
            this.repack();
            this.update();
        });
        JPanel mainPanel = new JPanel((LayoutManager)new VerticalLayout(15));
        JPanel filterPanel = new JPanel(new BorderLayout());
        JPanel leftPanel = new JPanel((LayoutManager)new VerticalLayout(20));
        leftPanel.add(this.buildSourcePanel());
        leftPanel.add(this.buildTypesPanel());
        filterPanel.add((Component)leftPanel, "West");
        filterPanel.add(this.buildAdvancedPanel(), "East");
        mainPanel.add(filterPanel);
        mainPanel.add(this.advancedFilterCheckbox);
        mainPanel.add(this.buildResetPanel());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 5, 0, 5));
        return mainPanel;
    }

    private Component buildSourcePanel() {
        ItemListener sourceItemListener = e -> {
            if (this.ignoreCallbacks) {
                return;
            }
            JCheckBox cb = (JCheckBox)e.getItem();
            String name = cb.getText();
            this.setChanged(true);
            this.filter.setFilter(name, cb.isSelected());
            this.update();
        };
        String[] sourceNames = this.filter.getSourceFilterNames();
        JPanel panel = new JPanel(new GridLayout(0, 2));
        for (String sourceName : sourceNames) {
            GCheckBox cb = new GCheckBox(sourceName);
            this.checkBoxMap.put(sourceName, (JCheckBox)cb);
            cb.addItemListener(sourceItemListener);
            cb.setToolTipText(HTMLUtilities.toHTML((String)this.filter.getFilterDescription(sourceName)));
            panel.add((Component)cb);
        }
        panel.setBorder(BorderFactory.createTitledBorder("Symbol Source"));
        return panel;
    }

    private Component buildAdvancedPanel() {
        String[] filterNames;
        this.advancedPanel = new JPanel(new BorderLayout());
        JPanel infoPanel = new JPanel((LayoutManager)new HorizontalLayout(20));
        ImageIcon icon = ResourceManager.loadImage((String)"images/information.png");
        infoPanel.add((Component)new GIconLabel((Icon)icon));
        infoPanel.add((Component)new GHtmlLabel(HTMLUtilities.toHTML((String)"Advanced filters do not apply to all symbol types.\nAll symbols without applicable advanced filters will\nbe included. If more than one advanced filter is\napplicable to a symbol type, then those symbols will\nbe included if any of the applicable filters match. \nFilters that are not applicable to any of the selected\nsymbol types are disabled.")));
        JPanel filtersPanel = new JPanel(new GridLayout(0, 2));
        filtersPanel.setBorder(BorderFactory.createEmptyBorder(0, 40, 0, 0));
        for (String filterName : filterNames = this.filter.getAdvancedFilterNames()) {
            GCheckBox cb = new GCheckBox(filterName);
            this.checkBoxMap.put(filterName, (JCheckBox)cb);
            cb.addItemListener(this.checkboxListener);
            cb.setToolTipText(HTMLUtilities.toHTML((String)this.filter.getFilterDescription(filterName)));
            filtersPanel.add((Component)cb);
        }
        this.advancedFilterPanel = new JPanel((LayoutManager)new VerticalLayout(10));
        this.advancedFilterPanel.setBorder(BorderFactory.createTitledBorder("Advanced Filters"));
        this.advancedFilterPanel.add(filtersPanel);
        this.advancedFilterPanel.add(infoPanel);
        return this.advancedPanel;
    }

    private Component buildTypesPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Symbol Types"));
        panel.add(this.buildLabelTypesPanel("Label Symbols", this.filter.getLabelTypeFilterNames()), "West");
        panel.add(this.buildLabelTypesPanel("Non-label Symbols", this.filter.getNonLabelTypeFilterNames()), "East");
        panel.add(this.buildSelectButtonPanel(), "South");
        return panel;
    }

    private Component buildLabelTypesPanel(String title, String[] filterNames) {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(0));
        panel.setBorder(BorderFactory.createTitledBorder(title));
        for (String filterName : filterNames) {
            GCheckBox cb = new GCheckBox(filterName);
            cb.setName(filterName);
            this.checkBoxMap.put(filterName, (JCheckBox)cb);
            cb.addItemListener(this.checkboxListener);
            cb.setToolTipText(HTMLUtilities.toHTML((String)this.filter.getFilterDescription(filterName)));
            panel.add((Component)cb);
        }
        return panel;
    }

    private void setTypeFiltersActive(boolean active) {
        JCheckBox cb;
        String[] typeNames;
        for (String typeName : typeNames = this.filter.getLabelTypeFilterNames()) {
            cb = this.checkBoxMap.get(typeName);
            cb.setSelected(active);
        }
        for (String typeName : typeNames = this.filter.getNonLabelTypeFilterNames()) {
            cb = this.checkBoxMap.get(typeName);
            cb.setSelected(active);
        }
    }

    private Component buildSelectButtonPanel() {
        JPanel panel = new JPanel((LayoutManager)new MiddleLayout());
        JPanel innerPanel = new JPanel(new GridLayout(0, 2, 30, 30));
        panel.add(innerPanel);
        JButton b1 = new JButton("Select All");
        JButton b2 = new JButton("Clear All");
        b1.addActionListener(e -> this.setTypeFiltersActive(true));
        b2.addActionListener(e -> this.setTypeFiltersActive(false));
        innerPanel.add(b1);
        innerPanel.add(b2);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        return panel;
    }

    private Component buildResetPanel() {
        JPanel panel = new JPanel((LayoutManager)new MiddleLayout());
        JPanel panel2 = new JPanel(new GridLayout(1, 0, 20, 0));
        JButton button1 = new JButton("Reset Filters");
        button1.addActionListener(e -> {
            this.setStatusText("");
            this.filter.setFilterDefaults();
            this.initCheckBoxes();
            this.setChanged(true);
        });
        panel2.add(button1);
        panel.add(panel2);
        return panel;
    }

    private void clearAdvancedFilters() {
        String[] filterNames;
        for (String filterName : filterNames = this.filter.getAdvancedFilterNames()) {
            if (!this.filter.isActive(filterName)) continue;
            JCheckBox cb = this.checkBoxMap.get(filterName);
            cb.setSelected(false);
        }
    }

    public void adjustFilter(ComponentProvider provider, SymbolTableModel model) {
        this.keyModel = model;
        this.filter = new NewSymbolFilter(model.getFilter());
        this.initCheckBoxes();
        this.tool.showDialog((DialogComponentProvider)this, provider);
        model = null;
    }

    private void update() {
        this.updateStatus();
        this.updateAdvancedFilterEnablement();
        this.updateOkAndApply();
    }

    private void updateStatus() {
        if (this.filter.getActiveSourceFilterCount() == 0) {
            this.setStatusText("You must have at least one source category selected!");
        } else if (this.filter.getActiveTypeFilterCount() == 0) {
            this.setStatusText("You must have at least one symbol type selected!");
        } else {
            this.setStatusText("");
        }
    }

    private void updateAdvancedFilterEnablement() {
        String[] filterNames;
        for (String filterName : filterNames = this.filter.getAdvancedFilterNames()) {
            JCheckBox cb = this.checkBoxMap.get(filterName);
            cb.setEnabled(this.filter.isEnabled(filterName));
        }
    }

    private void updateOkAndApply() {
        boolean b = this.isChanged && this.filter.getActiveTypeFilterCount() > 0 && this.filter.getActiveSourceFilterCount() > 0;
        this.setOkEnabled(b);
        this.setApplyEnabled(b);
    }

    protected void okCallback() {
        this.applyCallback();
        this.close();
    }

    protected void applyCallback() {
        if (this.keyModel == null) {
            return;
        }
        if (!this.isChanged) {
            return;
        }
        this.keyModel.setFilter(new NewSymbolFilter(this.filter));
        this.setChanged(false);
        this.tool.setConfigChanged(true);
    }

    private void setChanged(boolean b) {
        this.isChanged = b;
        this.updateOkAndApply();
    }

    NewSymbolFilter getFilter() {
        return this.filter;
    }

    class FilterCheckboxItemListener
    implements ItemListener {
        FilterCheckboxItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (FilterDialog.this.ignoreCallbacks) {
                return;
            }
            JCheckBox cb = (JCheckBox)e.getItem();
            String name = cb.getText();
            FilterDialog.this.setChanged(true);
            FilterDialog.this.filter.setFilter(name, cb.isSelected());
            FilterDialog.this.update();
        }
    }
}

