/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.disassembler;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.disassembler.DisassemblerPlugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;

class ArmDisassembleAction
extends ListingContextAction {
    private DisassemblerPlugin plugin;
    private boolean disassembleThumb = false;

    public ArmDisassembleAction(DisassemblerPlugin plugin, String groupName, boolean disassembleThumb) {
        super("Disassemble " + (disassembleThumb ? "Thumb" : "Arm"), plugin.getName());
        this.plugin = plugin;
        this.disassembleThumb = disassembleThumb;
        this.setPopupMenuData(new MenuData(new String[]{"Disassemble - " + (disassembleThumb ? "Thumb" : "Arm")}, null, groupName));
        int keyEvent = disassembleThumb ? 123 : 122;
        this.setKeyBindingData(new KeyBindingData(keyEvent, 0));
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        this.plugin.disassembleArmCallback(context, this.disassembleThumb);
    }

    @Override
    public boolean isEnabledForContext(ListingActionContext context) {
        Address address = context.getAddress();
        if (address == null) {
            return false;
        }
        Program program = context.getProgram();
        Language lang = program.getLanguage();
        Processor proc = lang.getProcessor();
        if (!"ARM".equals(proc.toString())) {
            return false;
        }
        Register register = context.getProgram().getProgramContext().getRegister("TMode");
        if (register == null) {
            return false;
        }
        return this.plugin.checkDisassemblyEnabled(context, address, true);
    }
}

