/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.MenuData;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.app.plugin.core.navigation.FindAppliedDataTypesService;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import javax.swing.SwingUtilities;

public class FindReferencesToField
extends CompositeEditorTableAction {
    public static final String ACTION_NAME = "Find Uses of";
    private static final String GROUP_NAME = "1_BASIC_EDITOR_ACTION";
    private static final String DESCRIPTION = "Find uses of field in the selected row";
    private static String[] popupPath = new String[]{"Find Uses of"};

    public FindReferencesToField(CompositeEditorProvider provider) {
        super(provider, "Editor: Find Uses of", GROUP_NAME, popupPath, null, null);
        this.setDescription(DESCRIPTION);
        this.adjustEnablement();
        this.setHelpLocation(new HelpLocation("LocationReferencesPlugin", "Data_Types"));
    }

    public void actionPerformed(ActionContext context) {
        FindAppliedDataTypesService service = (FindAppliedDataTypesService)this.tool.getService(FindAppliedDataTypesService.class);
        if (service == null) {
            Msg.showError((Object)this, null, (String)"Missing Plugin", (Object)"The FindAppliedDataTypesService is not installed.\nPlease add the plugin implementing this service.");
            return;
        }
        String fieldName = this.getFieldName();
        Composite composite = this.model.getOriginalComposite();
        SwingUtilities.invokeLater(() -> service.findAndDisplayAppliedDataTypeAddresses(composite, fieldName));
    }

    private String getFieldName() {
        int[] rows = this.model.getSelectedComponentRows();
        if (rows.length == 0) {
            return null;
        }
        int row = rows[0];
        DataTypeComponent dtComponet = this.model.getComponent(row);
        String fieldName = dtComponet.getFieldName();
        return fieldName;
    }

    @Override
    public void adjustEnablement() {
        this.setEnabled(false);
        if (this.model.getSelectedComponentRows().length != 1) {
            return;
        }
        Composite composite = this.model.getOriginalComposite();
        if (composite == null) {
            return;
        }
        String fieldName = this.getFieldName();
        if (fieldName == null) {
            return;
        }
        this.setEnabled(true);
        this.updateMenuName(fieldName);
    }

    private void updateMenuName(String name) {
        String menuName = "Find Uses of " + name;
        MenuData data = this.getPopupMenuData().cloneData();
        data.setMenuPath(new String[]{menuName});
        this.setPopupMenuData(data);
    }
}

