/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import ghidra.app.merge.listing.AbstractListingMerger;
import ghidra.app.merge.listing.ListingMergeManager;
import ghidra.app.merge.listing.VerticalChoicesPanel;
import ghidra.app.merge.tool.ListingMergePanel;
import ghidra.app.merge.util.ConflictUtility;
import ghidra.app.merge.util.MergeUtilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.util.ProgramConflictException;
import ghidra.program.util.ProgramDiffFilter;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class CommentMerger
extends AbstractListingMerger {
    static final String COMMENTS_PHASE = "Comments";
    private int programMergeType;
    private AddressSet conflictPlate;
    private AddressSet conflictPre;
    private AddressSet conflictEol;
    private AddressSet conflictRepeat;
    private AddressSet conflictPost;
    private int plateCommentChoice = 0;
    private int preCommentChoice = 0;
    private int eolCommentChoice = 0;
    private int repeatCommentChoice = 0;
    private int postCommentChoice = 0;
    private VerticalChoicesPanel conflictPanel;

    CommentMerger(ListingMergeManager listingMergeMgr) {
        super(listingMergeMgr);
    }

    @Override
    public void init() {
        super.init();
        this.conflictPlate = new AddressSet();
        this.conflictPre = new AddressSet();
        this.conflictEol = new AddressSet();
        this.conflictRepeat = new AddressSet();
        this.conflictPost = new AddressSet();
    }

    @Override
    public String getConflictType() {
        return "Comment";
    }

    @Override
    public boolean apply() {
        this.conflictOption = this.conflictPanel.getSelectedOptions();
        if (this.conflictPanel.getUseForAll()) {
            this.setChoiceForCommentType(this.programMergeType, this.conflictOption);
        }
        return super.apply();
    }

    @Override
    public void autoMerge(int progressMin, int progressMax, TaskMonitor monitor) throws ProgramConflictException, MemoryAccessException, CancelledException {
        this.initializeAutoMerge("Auto-merging Comments and determining conflicts.", progressMin, progressMax, monitor);
        this.updateProgress(0, "Auto-merging Plate Comments and determining conflicts.");
        this.autoMerge(64, this.conflictPlate, monitor);
        this.updateProgress(20, "Auto-merging Pre-Comments and determining conflicts.");
        this.autoMerge(16, this.conflictPre, monitor);
        this.updateProgress(40, "Auto-merging End of Line Comments and determining conflicts.");
        this.autoMerge(8, this.conflictEol, monitor);
        this.updateProgress(60, "Auto-merging Repeatable Comments and determining conflicts.");
        this.autoMerge(128, this.conflictRepeat, monitor);
        this.updateProgress(80, "Auto-merging Post-Comments and determining conflicts.");
        this.autoMerge(32, this.conflictPost, monitor);
        this.updateProgress(100, "Done auto-merging Comments and determining conflicts.");
    }

    private void autoMerge(int diffType, AddressSet conflictSet, TaskMonitor monitor) throws ProgramConflictException, CancelledException {
        AddressSetView latestDetailSet = this.listingMergeMgr.diffOriginalLatest.getDifferences(new ProgramDiffFilter(diffType), monitor);
        AddressSetView myDetailSet = this.listingMergeMgr.diffOriginalMy.getDifferences(new ProgramDiffFilter(diffType), monitor);
        AddressSet autoSet = new AddressSet();
        AddressSet overlapSet = new AddressSet();
        MergeUtilities.adjustSets(latestDetailSet, myDetailSet, autoSet, overlapSet);
        this.listingMergeMgr.mergeMy.mergeCommentType((AddressSetView)autoSet, this.getMergeCommentType(diffType), 1, monitor);
        AddressSetView latestMySet = this.listingMergeMgr.diffLatestMy.getTypeDiffs(diffType, (AddressSetView)overlapSet, monitor);
        conflictSet.add(latestMySet);
    }

    private boolean hasConflict(Address addr, int programMergeCommentType) {
        switch (programMergeCommentType) {
            case 32: {
                return this.conflictPlate.contains(addr);
            }
            case 64: {
                return this.conflictPre.contains(addr);
            }
            case 128: {
                return this.conflictEol.contains(addr);
            }
            case 256: {
                return this.conflictRepeat.contains(addr);
            }
            case 512: {
                return this.conflictPost.contains(addr);
            }
        }
        return false;
    }

    @Override
    public boolean hasConflict(Address addr) {
        return this.hasConflict(addr, 32) || this.hasConflict(addr, 64) || this.hasConflict(addr, 128) || this.hasConflict(addr, 256) || this.hasConflict(addr, 512);
    }

    @Override
    public int getConflictCount(Address addr) {
        int count = 0;
        if (this.hasConflict(addr, 32)) {
            ++count;
        }
        if (this.hasConflict(addr, 64)) {
            ++count;
        }
        if (this.hasConflict(addr, 128)) {
            ++count;
        }
        if (this.hasConflict(addr, 256)) {
            ++count;
        }
        if (this.hasConflict(addr, 512)) {
            ++count;
        }
        return count;
    }

    private void setupConflictsPanel(ListingMergePanel listingPanel, Address addr, int programMergeType, ChangeListener changeListener) {
        String msg;
        if (this.conflictPanel == null) {
            this.conflictPanel = new VerticalChoicesPanel();
            this.currentConflictPanel = this.conflictPanel;
            this.conflictPanel.setTitle("Comment");
        } else {
            this.conflictPanel.clear();
        }
        int type = this.getCodeUnitCommentType(programMergeType);
        int choice = this.getChoiceForCommentType(programMergeType);
        boolean useForAll = choice != 0;
        this.conflictPanel.setUseForAll(useForAll);
        String conflictTypeText = this.getTypeName(programMergeType);
        this.conflictPanel.setConflictType(conflictTypeText + " Comment");
        String originalComment = this.originalPgm.getListing().getComment(type, addr);
        String latestComment = this.latestPgm.getListing().getComment(type, addr);
        String myComment = this.myPgm.getListing().getComment(type, addr);
        String originalTrunc = ConflictUtility.getTruncatedHTMLString(originalComment, 160);
        String latestTrunc = ConflictUtility.getTruncatedHTMLString(latestComment, 160);
        String myTrunc = ConflictUtility.getTruncatedHTMLString(myComment, 160);
        this.conflictPanel.setRowHeader(new String[]{"Option", "Comment"});
        if (latestComment == null || myComment == null) {
            String[] latestStrings = new String[]{this.createButtonText("Latest", programMergeType, latestComment), latestTrunc};
            String[] myStrings = new String[]{this.createButtonText("Checked Out", programMergeType, myComment), myTrunc};
            this.conflictPanel.addRadioButtonRow(latestStrings, "LatestVersionRB", 2, changeListener);
            this.conflictPanel.addRadioButtonRow(myStrings, "CheckedOutVersionRB", 4, changeListener);
            msg = conflictTypeText + " comments differ. Select whether or not to keep the comment.";
        } else {
            String[] latestStrings = new String[]{this.createCheckBoxText("Latest", programMergeType, latestComment), latestTrunc};
            String[] myStrings = new String[]{this.createCheckBoxText("Checked Out", programMergeType, myComment), myTrunc};
            this.conflictPanel.addCheckBoxRow(latestStrings, "LatestVersionCheckBox", 2, changeListener);
            this.conflictPanel.addCheckBoxRow(myStrings, "CheckedOutVersionCheckBox", 4, changeListener);
            msg = this.getTypeName(programMergeType) + " comments differ. Select either or both of the comments.";
        }
        this.conflictPanel.addInfoRow(new String[]{"'Original' version", originalTrunc});
        this.conflictPanel.setHeader(msg);
    }

    @Override
    public void mergeConflicts(ListingMergePanel listingPanel, Address addr, int chosenConflictOption, TaskMonitor monitor) throws CancelledException, MemoryAccessException {
        this.mergeConflicts(32, listingPanel, addr, chosenConflictOption, monitor);
        this.mergeConflicts(64, listingPanel, addr, chosenConflictOption, monitor);
        this.mergeConflicts(128, listingPanel, addr, chosenConflictOption, monitor);
        this.mergeConflicts(256, listingPanel, addr, chosenConflictOption, monitor);
        this.mergeConflicts(512, listingPanel, addr, chosenConflictOption, monitor);
    }

    private void mergeConflicts(int programMergeFilterCommentType, ListingMergePanel listingPanel, Address addr, int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        if (!this.hasConflict(addr, programMergeFilterCommentType)) {
            return;
        }
        monitor.setMessage("Resolving " + this.getTypeName(programMergeFilterCommentType) + " Comment conflicts.");
        int choiceForCommentType = this.getChoiceForCommentType(programMergeFilterCommentType);
        if (choiceForCommentType != 0) {
            this.merge(addr, programMergeFilterCommentType, choiceForCommentType, monitor);
            return;
        }
        if (chosenConflictOption == 0 && this.mergeManager != null) {
            this.showMergePanel(listingPanel, addr, programMergeFilterCommentType, monitor);
            monitor.checkCanceled();
        } else {
            this.merge(addr, programMergeFilterCommentType, chosenConflictOption, monitor);
        }
    }

    private void merge(Address addr, int programMergeFilterCommentType, int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        boolean both = false;
        if ((chosenConflictOption & 1) != 0) {
            this.listingMergeMgr.mergeOriginal.mergeComment(new AddressSet(addr), programMergeFilterCommentType, both, monitor);
            both = true;
        }
        if ((chosenConflictOption & 2) != 0) {
            this.listingMergeMgr.mergeLatest.mergeComment(new AddressSet(addr), programMergeFilterCommentType, both, monitor);
            both = true;
        }
        if ((chosenConflictOption & 4) != 0) {
            this.listingMergeMgr.mergeMy.mergeComment(new AddressSet(addr), programMergeFilterCommentType, both, monitor);
            both = true;
        }
    }

    private int getCodeUnitCommentType(int programMergeCommentType) {
        switch (programMergeCommentType) {
            case 32: {
                return 3;
            }
            case 64: {
                return 1;
            }
            case 128: {
                return 0;
            }
            case 256: {
                return 4;
            }
            case 512: {
                return 2;
            }
        }
        return -1;
    }

    private int getMergeCommentType(int diffCommentType) {
        switch (diffCommentType) {
            case 64: {
                return 32;
            }
            case 16: {
                return 64;
            }
            case 8: {
                return 128;
            }
            case 128: {
                return 256;
            }
            case 32: {
                return 512;
            }
        }
        return -1;
    }

    private int getChoiceForCommentType(int programMergeCommentType) {
        switch (programMergeCommentType) {
            case 32: {
                return this.plateCommentChoice;
            }
            case 64: {
                return this.preCommentChoice;
            }
            case 128: {
                return this.eolCommentChoice;
            }
            case 256: {
                return this.repeatCommentChoice;
            }
            case 512: {
                return this.postCommentChoice;
            }
        }
        return 0;
    }

    private void setChoiceForCommentType(int programMergeCommentType, int choiceForCommentType) {
        switch (programMergeCommentType) {
            case 32: {
                this.plateCommentChoice = choiceForCommentType;
                break;
            }
            case 64: {
                this.preCommentChoice = choiceForCommentType;
                break;
            }
            case 128: {
                this.eolCommentChoice = choiceForCommentType;
                break;
            }
            case 256: {
                this.repeatCommentChoice = choiceForCommentType;
                break;
            }
            case 512: {
                this.postCommentChoice = choiceForCommentType;
                break;
            }
            default: {
                Msg.showError((Object)this, (Component)this.listingMergePanel, (String)"Unrecognized Comment Type", (Object)("Unrecognized indicator (" + programMergeCommentType + ") for comment type to merge."));
            }
        }
    }

    private void showMergePanel(final ListingMergePanel listingPanel, final Address addr, final int programMergeCommentType, TaskMonitor monitor) {
        this.currentAddress = addr;
        this.programMergeType = programMergeCommentType;
        this.currentMonitor = monitor;
        try {
            final ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    CommentMerger.this.conflictOption = CommentMerger.this.conflictPanel.getSelectedOptions();
                    if (CommentMerger.this.conflictOption == 0) {
                        if (CommentMerger.this.mergeManager != null) {
                            CommentMerger.this.mergeManager.setApplyEnabled(false);
                            try {
                                CommentMerger.this.merge(addr, programMergeCommentType, 2, CommentMerger.this.currentMonitor);
                            }
                            catch (CancelledException cancelledException) {
                                // empty catch block
                            }
                        }
                        return;
                    }
                    if (CommentMerger.this.mergeManager != null) {
                        CommentMerger.this.mergeManager.clearStatusText();
                    }
                    try {
                        CommentMerger.this.merge(addr, programMergeCommentType, CommentMerger.this.conflictOption, CommentMerger.this.currentMonitor);
                    }
                    catch (CancelledException cancelledException) {
                        // empty catch block
                    }
                    if (CommentMerger.this.mergeManager != null) {
                        CommentMerger.this.mergeManager.setApplyEnabled(true);
                    }
                }
            };
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    CommentMerger.this.setupConflictsPanel(listingPanel, CommentMerger.this.currentAddress, CommentMerger.this.programMergeType, changeListener);
                    listingPanel.setBottomComponent(CommentMerger.this.conflictPanel);
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Address addressToShow = CommentMerger.this.currentAddress;
                    listingPanel.clearAllBackgrounds();
                    if (addressToShow != null) {
                        listingPanel.paintAllBackgrounds(CommentMerger.this.getCodeUnitAddressSet(addressToShow));
                        listingPanel.goTo(addressToShow);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        if (this.mergeManager != null) {
            this.mergeManager.setApplyEnabled(false);
            this.mergeManager.showListingMergePanel(this.currentAddress);
        }
    }

    private String createCheckBoxText(String version, int programMergeCommentType, String comment) {
        return "Keep '" + version + "' " + this.getTypeName(programMergeCommentType) + " Comment";
    }

    private String createButtonText(String version, int programMergeCommentType, String comment) {
        if (comment != null) {
            return "Keep '" + version + "' " + this.getTypeName(programMergeCommentType) + " Comment";
        }
        return "Delete " + this.getTypeName(programMergeCommentType) + " Comment as in '" + version + "'";
    }

    private String getTypeName(int programMergeCommentType) {
        String typeStr;
        switch (programMergeCommentType) {
            case 32: {
                typeStr = "Plate";
                break;
            }
            case 64: {
                typeStr = "Pre";
                break;
            }
            case 128: {
                typeStr = "End of Line";
                break;
            }
            case 256: {
                typeStr = "Repeatable";
                break;
            }
            case 512: {
                typeStr = "Post";
                break;
            }
            default: {
                typeStr = "Unknown";
            }
        }
        return typeStr;
    }

    @Override
    public AddressSetView getConflicts() {
        AddressSet conflicts = new AddressSet();
        conflicts.add((AddressSetView)this.conflictPlate);
        conflicts.add((AddressSetView)this.conflictPre);
        conflicts.add((AddressSetView)this.conflictEol);
        conflicts.add((AddressSetView)this.conflictRepeat);
        conflicts.add((AddressSetView)this.conflictPost);
        return conflicts;
    }
}

