/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool;

import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceInterfaceImplementationPair;
import ghidra.framework.plugintool.util.PluginDescription;
import ghidra.framework.plugintool.util.PluginEventListener;
import ghidra.framework.plugintool.util.PluginUtils;
import ghidra.framework.plugintool.util.ServiceListener;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.classfinder.ExtensionPoint;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public abstract class Plugin
implements ExtensionPoint,
PluginEventListener,
ServiceListener {
    protected PluginTool tool;
    protected final String name = PluginUtils.getPluginNameFromClass(this.getClass());
    protected final PluginDescription pluginDescription = PluginDescription.getPluginDescription(this.getClass());
    private List<Class<?>> legacyRequiredServices = new ArrayList();
    private List<Class<? extends PluginEvent>> eventsProduced = new ArrayList<Class<? extends PluginEvent>>();
    private List<Class<? extends PluginEvent>> eventsConsumed = new ArrayList<Class<? extends PluginEvent>>();
    private List<ServiceInterfaceImplementationPair> services = new ArrayList<ServiceInterfaceImplementationPair>();
    private boolean constructorFinished = false;
    private boolean disposed = false;

    protected Plugin(PluginTool tool) {
        this.tool = tool;
        tool.addServiceListener(this);
        this.registerPluginImplementedServices();
        this.registerStaticEvents();
    }

    @Deprecated
    protected Plugin(String pluginName, PluginTool tool) {
        this(tool);
    }

    private void registerPluginImplementedServices() {
        for (Class<?> serviceClass : this.pluginDescription.getServicesProvided()) {
            if (!serviceClass.isInstance(this)) continue;
            this.doRegisterServiceProvided(serviceClass, this, false);
        }
    }

    private void registerStaticEvents() {
        for (Class<? extends PluginEvent> eventClass : this.pluginDescription.getEventsProduced()) {
            this.eventsProduced.add(eventClass);
            this.tool.registerEventProduced(eventClass);
        }
        for (Class<? extends PluginEvent> eventClass : this.pluginDescription.getEventsConsumed()) {
            this.eventsConsumed.add(eventClass);
            this.tool.addEventListener(eventClass, this);
        }
    }

    @Deprecated
    public static String getPluginName(Class<?> pluginClass) {
        if (pluginClass != Plugin.class && Plugin.class.isAssignableFrom(pluginClass)) {
            return pluginClass.getSimpleName();
        }
        return null;
    }

    protected void cleanup() {
        if (!this.disposed) {
            Throwable thr = null;
            try {
                this.disposed = true;
                this.dispose();
            }
            catch (Throwable t) {
                thr = t;
            }
            this.tool.removeServiceListener(this);
            this.legacyRequiredServices.clear();
            this.unregisterServices();
            this.unregisterEvents();
            this.tool.removeAll(this.getName());
            this.tool = null;
            if (thr != null) {
                throw new RuntimeException(thr);
            }
        }
    }

    public final String getName() {
        return this.name;
    }

    @Override
    public final void eventSent(PluginEvent event) {
        if (!SystemUtilities.isEqual((Object)event.getSourceName(), (Object)this.getName())) {
            this.processEvent(event);
        }
    }

    public void processEvent(PluginEvent event) {
    }

    public final PluginTool getTool() {
        return this.tool;
    }

    public Class<?>[] getSupportedDataTypes() {
        return new Class[0];
    }

    public boolean acceptData(DomainFile[] data) {
        return false;
    }

    public DomainFile[] getData() {
        return new DomainFile[0];
    }

    final void initServices() {
        this.constructorFinished = true;
        this.registerQueuedServices();
    }

    private void registerQueuedServices() {
        HashSet publishedServices = new HashSet(this.pluginDescription.getServicesProvided());
        for (ServiceInterfaceImplementationPair serviceInterfaceImplementationPair : this.services) {
            this.tool.addService(serviceInterfaceImplementationPair.interfaceClass, serviceInterfaceImplementationPair.provider);
            publishedServices.remove(serviceInterfaceImplementationPair.interfaceClass);
        }
        for (Class clazz : publishedServices) {
            Msg.warn((Object)this, (Object)("Plugin " + this.getName() + " did not register a service handler for: " + clazz));
        }
    }

    void processLastEvents(PluginEvent[] lastEvents) {
        for (PluginEvent lastEvent : lastEvents) {
            try {
                if (!this.eventsConsumed.contains(lastEvent.getClass())) continue;
                this.processEvent(lastEvent);
            }
            catch (Throwable t) {
                Msg.debug((Object)this, (Object)"Unexpected exception processing plugin event", (Throwable)t);
            }
        }
    }

    protected void init() {
    }

    protected void dispose() {
    }

    public void readConfigState(SaveState saveState) {
    }

    public void writeConfigState(SaveState saveState) {
    }

    public void writeDataState(SaveState saveState) {
    }

    public void readDataState(SaveState saveState) {
    }

    public void firePluginEvent(PluginEvent event) {
        if (this.tool != null) {
            event.setSourceName(this.getName());
            this.tool.firePluginEvent(event);
        }
    }

    Class<?>[] getServiceClasses() {
        Class[] classes = new Class[this.services.size()];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = this.services.get((int)i).interfaceClass;
        }
        return classes;
    }

    public void serviceAdded(Class<?> interfaceClass, Object service) {
    }

    public void serviceRemoved(Class<?> interfaceClass, Object service) {
    }

    public boolean dependsUpon(Plugin plugin) {
        for (Class<?> c : Plugin.getList(this.pluginDescription.getServicesRequired(), this.legacyRequiredServices)) {
            if (!plugin.isOnlyProviderOfService(c)) continue;
            return true;
        }
        return false;
    }

    public List<Class<?>> getMissingRequiredServices() {
        ArrayList missingServices = new ArrayList();
        for (Class<?> requiredServiceClass : Plugin.getList(this.pluginDescription.getServicesRequired(), this.legacyRequiredServices)) {
            if (this.tool.getService(requiredServiceClass) != null) continue;
            missingServices.add(requiredServiceClass);
        }
        return missingServices;
    }

    public boolean hasMissingRequiredService() {
        for (Class<?> depClass : Plugin.getList(this.pluginDescription.getServicesRequired(), this.legacyRequiredServices)) {
            if (this.tool.getService(depClass) != null) continue;
            return true;
        }
        return false;
    }

    private static <T> List<T> getList(List<T> l1, List<T> l2) {
        return !l1.isEmpty() ? l1 : l2;
    }

    @Deprecated
    protected final void registerEventProduced(Class<? extends PluginEvent> eventClass) {
        this.eventsProduced.add(eventClass);
        this.tool.registerEventProduced(eventClass);
    }

    private void unregisterEvents() {
        for (Class<? extends PluginEvent> c : this.eventsConsumed) {
            this.tool.removeEventListener(c, this);
        }
        for (Class<? extends PluginEvent> c : this.eventsProduced) {
            this.tool.unregisterEventProduced(c);
        }
    }

    @Deprecated
    protected final void registerEventConsumed(Class<? extends PluginEvent> eventClass) {
        this.registerDynamicEventConsumed(eventClass);
    }

    protected final void registerDynamicEventConsumed(Class<? extends PluginEvent> eventClass) {
        this.eventsConsumed.add(eventClass);
        this.tool.addEventListener(eventClass, this);
    }

    private void doRegisterServiceProvided(Class<?> interfaceClass, Object service, boolean dynamicRegister) {
        Objects.requireNonNull(service, "Service instance can not be null! Interface: " + interfaceClass.getName());
        if (!this.pluginDescription.getServicesProvided().contains(interfaceClass)) {
            Msg.warn((Object)this, (Object)("Services must be advertised in @PluginInfo annotation - service " + interfaceClass + "; from plugin " + this.getName()));
        }
        this.services.add(new ServiceInterfaceImplementationPair(interfaceClass, service));
        if (this.constructorFinished) {
            this.tool.addService(interfaceClass, service);
        }
    }

    protected final <T> void registerServiceProvided(Class<? super T> interfaceClass, T service) {
        this.doRegisterServiceProvided(interfaceClass, service, false);
    }

    protected final <T> void registerDynamicServiceProvided(Class<? super T> interfaceClass, T service) {
        this.doRegisterServiceProvided(interfaceClass, service, true);
    }

    protected final List<Class<?>> getServicesRequired() {
        return Plugin.getList(this.pluginDescription.getServicesRequired(), this.legacyRequiredServices);
    }

    private void unregisterServices() {
        for (ServiceInterfaceImplementationPair siip : this.services) {
            this.tool.removeService(siip.interfaceClass, siip.provider);
        }
    }

    @Deprecated
    protected final void registerServiceUsed(Class<?> interfaceClass, boolean isDependency) {
        if (isDependency) {
            this.legacyRequiredServices.add(interfaceClass);
        }
    }

    protected final void deregisterService(Class<?> interfaceClass, Object service) {
        for (int i = 0; i < this.services.size(); ++i) {
            ServiceInterfaceImplementationPair s = this.services.get(i);
            if (s.interfaceClass != interfaceClass || s.provider != service) continue;
            this.tool.removeService(interfaceClass, service);
            this.services.remove(i);
            break;
        }
    }

    boolean providesService(Class<?> interfaceClass) {
        for (ServiceInterfaceImplementationPair siip : this.services) {
            if (siip.interfaceClass != interfaceClass) continue;
            return true;
        }
        return false;
    }

    List<Object> getServiceProviderInstances(Class<?> interfaceClass) {
        ArrayList<Object> providerInstances = new ArrayList<Object>();
        for (ServiceInterfaceImplementationPair myService : this.services) {
            if (myService.interfaceClass != interfaceClass) continue;
            providerInstances.add(myService.provider);
        }
        return providerInstances;
    }

    private boolean isOnlyProviderOfService(Class<?> serviceClass) {
        if (this.tool == null) {
            return false;
        }
        ?[] activeServiceInstances = this.tool.getServices(serviceClass);
        int count = 0;
        for (ServiceInterfaceImplementationPair myService : this.services) {
            if (myService.interfaceClass != serviceClass) continue;
            ++count;
        }
        return activeServiceInstances.length != 0 && activeServiceInstances.length == count;
    }

    protected boolean canClose() {
        return true;
    }

    protected boolean canCloseDomainObject(DomainObject dObj) {
        return true;
    }

    protected void prepareToSave(DomainObject dObj) {
    }

    protected boolean saveData() {
        return true;
    }

    protected boolean hasUnsaveData() {
        return false;
    }

    protected void close() {
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Plugin)) {
            return false;
        }
        Plugin plugin = (Plugin)obj;
        if (this.tool != plugin.tool) {
            return false;
        }
        return plugin.name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void restoreTransientState(Object state) {
    }

    public Object getTransientState() {
        return null;
    }

    public void dataStateRestoreCompleted() {
    }

    public Object getUndoRedoState(DomainObject domainObject) {
        return null;
    }

    public void restoreUndoRedoState(DomainObject domainObject, Object state) {
    }

    public final PluginDescription getPluginDescription() {
        return this.pluginDescription;
    }
}

