/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.dnd.GenericDataFlavor;
import ghidra.framework.main.ToolButton;
import ghidra.util.Msg;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class ToolButtonTransferable
implements Transferable,
ClipboardOwner {
    public static DataFlavor localToolButtonFlavor = ToolButtonTransferable.createLocalToolButtonFlavor();
    private static DataFlavor[] flavors = new DataFlavor[]{localToolButtonFlavor};
    private static List flavorList = Arrays.asList(flavors);
    private ToolButton button;

    private static DataFlavor createLocalToolButtonFlavor() {
        try {
            return new GenericDataFlavor("application/x-java-jvm-local-objectref; class=ghidra.framework.main.ToolButton", "Local tool button object");
        }
        catch (Exception e) {
            Msg.showError(ToolButtonTransferable.class, null, null, null, (Throwable)e);
            return null;
        }
    }

    ToolButtonTransferable(ToolButton button) {
        this.button = button;
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor f) {
        return flavorList.contains(f);
    }

    @Override
    public synchronized Object getTransferData(DataFlavor f) throws UnsupportedFlavorException, IOException {
        if (f.equals(localToolButtonFlavor)) {
            return this.button;
        }
        throw new UnsupportedFlavorException(f);
    }

    public String toString() {
        return "ToolButtonTransferable";
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    void clearTransferData() {
        this.button = null;
    }
}

