/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.ConstantPropagationAnalyzer;
import ghidra.app.plugin.core.analysis.ConstantPropagationContextEvaluator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.SymbolicPropogator;
import ghidra.program.util.VarnodeContext;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class HCS12ConstantAnalyzer
extends ConstantPropagationAnalyzer {
    private static final String PROCESSOR_NAME = "HCS12";

    public HCS12ConstantAnalyzer() {
        super(PROCESSOR_NAME);
    }

    public boolean canAnalyze(Program program) {
        boolean canAnalyze = program.getLanguage().getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)PROCESSOR_NAME));
        return canAnalyze;
    }

    private long hcs12TranslatePagedAddress(long addrWordOffset) {
        long page = addrWordOffset >> 16 & 0xFFL;
        long addr = addrWordOffset & 0xFFFFL;
        if ((addr & 0xFC00L) == 0L) {
            return addr;
        }
        if ((addr & 0xFC00L) == 2048L) {
            return 0x100000L | (page << 10 | addr & 0x3FFL);
        }
        if ((addr & 0xFC00L) == 3072L) {
            return 0x13FC00L | addr & 0x3FFL;
        }
        if ((addr & 0xF000L) == 4096L) {
            return page << 12 | addr & 0xFFFL;
        }
        if ((addr & 0xF000L) == 8192L) {
            return 0xFE000L | addr & 0xFFFL;
        }
        if ((addr & 0xF000L) == 12288L) {
            return 0xFF000L | addr & 0xFFFL;
        }
        if ((addr & 0xC000L) == 16384L) {
            return 0x7F4000L | addr & 0x3FFFL;
        }
        if ((addr & 0xC000L) == 32768L) {
            return 0x400000L | page << 14 | addr & 0x3FFFL;
        }
        if ((addr & 0xC000L) == 49152L) {
            return 0x7FC000L | addr & 0x3FFFL;
        }
        return addr;
    }

    public AddressSetView flowConstants(Program program, Address flowStart, AddressSetView flowSet, SymbolicPropogator symEval, TaskMonitor monitor) throws CancelledException {
        ConstantPropagationContextEvaluator eval = new ConstantPropagationContextEvaluator(this.trustWriteMemOption){

            public boolean evaluateReference(VarnodeContext context, Instruction instr, int pcodeop, Address address, int size, RefType refType) {
                if ((refType.isRead() || refType.isWrite()) && this.adjustPagedAddress(instr, address, refType)) {
                    return false;
                }
                return super.evaluateReference(context, instr, pcodeop, address, size, refType);
            }

            public Address evaluateConstant(VarnodeContext context, Instruction instr, int pcodeop, Address constant, int size, RefType refType) {
                return super.evaluateConstant(context, instr, pcodeop, constant, size, refType);
            }

            private boolean adjustPagedAddress(Instruction instr, Address address, RefType refType) {
                PcodeOp[] pcode;
                for (PcodeOp op : pcode = instr.getPcode()) {
                    String opName;
                    int numin = op.getNumInputs();
                    if (numin < 1 || op.getOpcode() != 9 || (opName = instr.getProgram().getLanguage().getUserDefinedOpName((int)op.getInput(0).getOffset())) == null || !opName.equals("segment") || numin <= 2) continue;
                    long high = address.getOffset() >> 16;
                    long low = address.getOffset() & 0xFFFFL;
                    address = address.getNewAddress(high << 14 | low & 0x3FFFL);
                    this.makeReference(instr, address, refType);
                    return true;
                }
                return false;
            }

            private void makeReference(Instruction instr, Address address, RefType refType) {
                int index = refType.isRead() ? 1 : 0;
                instr.addOperandReference(index, address, refType, SourceType.ANALYSIS);
            }
        };
        return symEval.flowConstants(flowStart, flowSet, (ContextEvaluator)eval, true, monitor);
    }
}

