/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.dialogs;

import docking.DialogComponentProvider;
import docking.DockingUtils;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class MultiLineInputDialog
extends DialogComponentProvider {
    private static final KeyStroke SUBMIT_KEYSTROKE = KeyStroke.getKeyStroke(10, DockingUtils.CONTROL_KEY_MODIFIER_MASK);
    private boolean isCanceled;
    private JTextArea inputTextArea;

    public MultiLineInputDialog(String title, String messageText, String initialValue, Icon icon) {
        super(title, true);
        this.addWorkPanel(this.build(messageText, icon, initialValue));
        this.setFocusComponent(this.inputTextArea);
        this.addOKButton();
        this.addCancelButton();
    }

    private JPanel build(String messageText, Icon icon, String initialValue) {
        JPanel dataPanel = new JPanel(new BorderLayout());
        this.inputTextArea = new JTextArea(10, 50);
        DockingUtils.installUndoRedo(this.inputTextArea);
        this.inputTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                KeyStroke keyStrokeForEvent = KeyStroke.getKeyStrokeForEvent(e);
                if (SUBMIT_KEYSTROKE.equals(keyStrokeForEvent)) {
                    MultiLineInputDialog.this.okCallback();
                }
            }
        });
        this.inputTextArea.setLineWrap(true);
        this.inputTextArea.setWrapStyleWord(true);
        if (initialValue != null) {
            this.inputTextArea.setText(initialValue);
        }
        this.inputTextArea.selectAll();
        GDLabel messageLabel = new GDLabel();
        ((JLabel)messageLabel).setText(messageText);
        messageLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        String metaKeyText = "Control";
        OperatingSystem OS = Platform.CURRENT_PLATFORM.getOperatingSystem();
        if (OS == OperatingSystem.MAC_OS_X) {
            metaKeyText = "Command";
        }
        GLabel hintLabel = new GLabel("(" + metaKeyText + "-Enter to accept)");
        hintLabel.setHorizontalAlignment(0);
        Font font = hintLabel.getFont();
        Font smallerFont = font.deriveFont(12.0f);
        Font smallItalicFont = smallerFont.deriveFont(2);
        hintLabel.setFont(smallItalicFont);
        hintLabel.setForeground(Color.LIGHT_GRAY);
        dataPanel.add((Component)messageLabel, "North");
        dataPanel.add((Component)new JScrollPane(this.inputTextArea), "Center");
        dataPanel.add((Component)hintLabel, "South");
        GDLabel iconLabel = new GDLabel();
        iconLabel.setIcon(icon);
        iconLabel.setVerticalAlignment(1);
        JPanel separatorPanel = new JPanel();
        separatorPanel.setPreferredSize(new Dimension(15, 1));
        JPanel iconPanel = new JPanel(new BorderLayout());
        iconPanel.add((Component)iconLabel, "Center");
        iconPanel.add((Component)separatorPanel, "East");
        JPanel workPanel = new JPanel(new BorderLayout());
        workPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        workPanel.add((Component)iconPanel, "West");
        workPanel.add((Component)dataPanel, "Center");
        return workPanel;
    }

    @Override
    protected void okCallback() {
        this.isCanceled = false;
        this.close();
    }

    @Override
    protected void cancelCallback() {
        this.isCanceled = true;
        this.close();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public String getValue() {
        if (this.isCanceled) {
            return null;
        }
        return this.inputTextArea.getText();
    }
}

