/*
 * Decompiled with CFR 0.152.
 */
package docking.menu;

import docking.DockingWindowManager;
import docking.EmptyBorderToggleButton;
import docking.action.ActionContextProvider;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.ToggleDockingActionIf;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class DockingToolbarButton
extends EmptyBorderToggleButton {
    private DockingActionIf dockableAction;
    private ActionContextProvider contextProvider;

    public DockingToolbarButton(DockingActionIf action, ActionContextProvider contextProvider) {
        super(action);
        this.contextProvider = contextProvider;
        this.setFocusable(false);
        this.addMouseListener(new MouseOverMouseListener());
        action.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected void initFromAction(DockingActionIf action) {
        this.dockableAction = action;
        super.initFromAction(action);
    }

    @Override
    protected void doActionPerformed(ActionEvent e) {
        if (this.dockableAction instanceof ToggleDockingActionIf) {
            ToggleDockingActionIf toggleAction;
            toggleAction.setSelected(!(toggleAction = (ToggleDockingActionIf)this.dockableAction).isSelected());
        }
        this.dockableAction.actionPerformed(this.contextProvider.getActionContext(null));
    }

    @Override
    protected boolean isButtonSelected() {
        if (this.dockableAction instanceof ToggleDockingAction) {
            return ((ToggleDockingAction)this.dockableAction).isSelected();
        }
        return false;
    }

    public DockingActionIf getDockingAction() {
        return this.dockableAction;
    }

    @Override
    public void setSelected(boolean b) {
        if (this.dockableAction instanceof ToggleDockingActionIf) {
            ((ToggleDockingActionIf)this.dockableAction).setSelected(b);
        }
        super.setSelected(b);
    }

    @Override
    public boolean isSelected() {
        if (this.dockableAction instanceof ToggleDockingActionIf) {
            return ((ToggleDockingActionIf)this.dockableAction).isSelected();
        }
        return super.isSelected();
    }

    @Override
    public void removeListeners() {
        this.dockableAction.removePropertyChangeListener(this.propertyChangeListener);
        super.removeListeners();
    }

    private class MouseOverMouseListener
    extends MouseAdapter {
        private MouseOverMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent me) {
            DockingWindowManager.setMouseOverAction(DockingToolbarButton.this.dockableAction);
        }

        @Override
        public void mouseExited(MouseEvent me) {
            DockingWindowManager.setMouseOverAction(null);
        }
    }
}

