/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.prop;

import ghidra.util.exception.AssertException;
import ghidra.util.exception.NoValueException;
import ghidra.util.prop.PropertyPage;
import ghidra.util.prop.PropertySet;
import ghidra.util.prop.PropertyVisitor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class IntPropertySet
extends PropertySet {
    private static final long serialVersionUID = 1L;

    public IntPropertySet(String name) {
        super(name, null);
    }

    @Override
    public int getDataSize() {
        return 4;
    }

    public void putInt(long index, int value) {
        PropertyPage page = this.getOrCreatePage(this.getPageID(index));
        int n = page.getSize();
        page.addInt(this.getPageOffset(index), value);
        this.numProperties += page.getSize() - n;
    }

    public int getInt(long index) throws NoValueException {
        PropertyPage page = this.getPage(this.getPageID(index));
        if (page != null) {
            return page.getInt(this.getPageOffset(index));
        }
        throw noValueException;
    }

    @Override
    protected void moveIndex(long from, long to) {
        try {
            int value = this.getInt(from);
            this.remove(from);
            this.putInt(to, value);
        }
        catch (NoValueException noValueException) {
            // empty catch block
        }
    }

    @Override
    protected void saveProperty(ObjectOutputStream oos, long index) throws IOException {
        try {
            oos.writeInt(this.getInt(index));
        }
        catch (NoValueException e) {
            throw new AssertException(e.getMessage());
        }
    }

    @Override
    protected void restoreProperty(ObjectInputStream ois, long index) throws IOException {
        this.putInt(index, ois.readInt());
    }

    @Override
    public void applyValue(PropertyVisitor visitor, long addr) {
        try {
            visitor.visit(this.getInt(addr));
        }
        catch (NoValueException noValueException) {
            // empty catch block
        }
    }
}

