/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.value;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.apache.jackrabbit.util.TransientFileFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BLOBValue
extends BLOBFileValue {
    private static Logger log = LoggerFactory.getLogger((Class)BLOBValue.class);
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final int MAX_BUFFER_SIZE = 65536;
    private final File file;
    private final boolean temp;
    private byte[] buffer = EMPTY_BYTE_ARRAY;
    private final FileSystemResource fsResource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BLOBValue(InputStream in, boolean temp) throws IOException {
        byte[] spoolBuffer = new byte[8192];
        int len = 0;
        OutputStream out = null;
        File spoolFile = null;
        try {
            int read;
            while ((read = in.read(spoolBuffer)) > 0) {
                if (out != null) {
                    out.write(spoolBuffer, 0, read);
                    len += read;
                    continue;
                }
                if (len + read > 65536) {
                    TransientFileFactory fileFactory = TransientFileFactory.getInstance();
                    spoolFile = fileFactory.createTransientFile("bin", null, null);
                    out = new FileOutputStream(spoolFile);
                    out.write(this.buffer, 0, len);
                    out.write(spoolBuffer, 0, read);
                    this.buffer = null;
                    len += read;
                    continue;
                }
                byte[] newBuffer = new byte[len + read];
                System.arraycopy(this.buffer, 0, newBuffer, 0, len);
                System.arraycopy(spoolBuffer, 0, newBuffer, len, read);
                this.buffer = newBuffer;
                len += read;
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        this.file = spoolFile;
        this.fsResource = null;
        this.temp = temp;
    }

    BLOBValue(byte[] bytes) {
        this.buffer = bytes;
        this.file = null;
        this.fsResource = null;
        this.temp = false;
    }

    BLOBValue(File file) throws IOException {
        String path = file.getCanonicalPath();
        if (!file.isFile()) {
            throw new IOException(path + ": the specified file does not exist");
        }
        if (!file.canRead()) {
            throw new IOException(path + ": the specified file can not be read");
        }
        this.file = file;
        this.fsResource = null;
        this.temp = false;
    }

    BLOBValue(FileSystemResource fsResource) throws IOException {
        try {
            if (!fsResource.exists()) {
                throw new IOException(fsResource.getPath() + ": the specified resource does not exist");
            }
        }
        catch (FileSystemException fse) {
            throw new IOException(fsResource.getPath() + ": Error while creating value: " + fse.toString());
        }
        this.fsResource = fsResource;
        this.file = null;
        this.temp = false;
    }

    public long getLength() {
        if (this.file != null) {
            if (this.file.exists()) {
                return this.file.length();
            }
            return -1L;
        }
        if (this.fsResource != null) {
            try {
                return this.fsResource.length();
            }
            catch (FileSystemException fse) {
                return -1L;
            }
        }
        return this.buffer.length;
    }

    public void discard() {
        if (!this.temp) {
            return;
        }
        if (this.file != null) {
            this.file.delete();
        } else if (this.buffer != null) {
            this.buffer = EMPTY_BYTE_ARRAY;
        }
    }

    public void delete(boolean pruneEmptyParentDirs) {
        if (this.file != null) {
            this.file.delete();
            if (pruneEmptyParentDirs) {
                for (File parent = this.file.getParentFile(); parent != null && parent.delete(); parent = parent.getParentFile()) {
                }
            }
        } else if (this.fsResource != null) {
            try {
                this.fsResource.delete(pruneEmptyParentDirs);
            }
            catch (FileSystemException fse) {
                log.warn("Error while deleting BLOBFileValue: " + fse.getMessage());
            }
        } else {
            this.buffer = EMPTY_BYTE_ARRAY;
        }
    }

    public boolean isImmutable() {
        return false;
    }

    public String toString() {
        if (this.file != null) {
            return this.file.toString();
        }
        if (this.fsResource != null) {
            return this.fsResource.toString();
        }
        return this.buffer.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BLOBValue) {
            BLOBValue other = (BLOBValue)obj;
            return (this.file == null ? other.file == null : this.file.equals(other.file)) && (this.fsResource == null ? other.fsResource == null : this.fsResource.equals(other.fsResource)) && Arrays.equals(this.buffer, other.buffer);
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public InputStream getStream() throws IllegalStateException, RepositoryException {
        if (this.file != null) {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException fnfe) {
                throw new RepositoryException("file backing binary value not found", (Throwable)fnfe);
            }
        }
        if (this.fsResource != null) {
            try {
                return this.fsResource.getInputStream();
            }
            catch (FileSystemException fse) {
                throw new RepositoryException(this.fsResource.getPath() + ": the specified resource does not exist", (Throwable)fse);
            }
        }
        return new ByteArrayInputStream(this.buffer);
    }

    public boolean isSmall() {
        return false;
    }
}

