/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.bundle.BundleDbPersistenceManager;
import org.apache.jackrabbit.core.persistence.bundle.util.DbNameIndex;
import org.apache.jackrabbit.core.persistence.bundle.util.NGKDbNameIndex;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OraclePersistenceManager
extends BundleDbPersistenceManager {
    private static Logger log = LoggerFactory.getLogger((Class)OraclePersistenceManager.class);
    public static final String TABLE_SPACE_VARIABLE = "${tableSpace}";
    protected String tableSpace;

    public OraclePersistenceManager() {
        this.setExternalBLOBs(false);
    }

    public String getTableSpace() {
        return this.tableSpace;
    }

    public void setTableSpace(String tableSpace) {
        this.tableSpace = tableSpace != null ? tableSpace.trim() : null;
    }

    public void init(PMContext context) throws Exception {
        if (this.getDriver() == null) {
            this.setDriver("oracle.jdbc.OracleDriver");
        }
        if (this.getUrl() == null) {
            this.setUrl("jdbc:oracle:thin:@127.0.0.1:1521:xe");
        }
        if (this.getSchema() == null) {
            this.setSchema("oracle");
        }
        if (this.getSchemaObjectPrefix() == null) {
            this.setSchemaObjectPrefix(context.getHomeDir().getName() + "_");
        }
        super.init(context);
        try {
            DatabaseMetaData metaData = this.connectionManager.getConnection().getMetaData();
            if (metaData.getDriverMajorVersion() < 10) {
                log.warn("Unsupported driver version detected: " + metaData.getDriverName() + " v" + metaData.getDriverVersion());
            }
        }
        catch (SQLException e) {
            log.warn("Can not retrieve driver version", (Throwable)e);
        }
    }

    protected DbNameIndex createDbNameIndex() throws SQLException {
        return new NGKDbNameIndex(this.connectionManager, this.schemaObjectPrefix);
    }

    protected boolean checkTablesWithUser() {
        return true;
    }

    protected String createSchemaSQL(String sql) {
        sql = Text.replace(sql, "${schemaObjectPrefix}", this.schemaObjectPrefix).trim();
        String tspace = this.tableSpace == null || "".equals(this.tableSpace) ? "" : "tablespace " + this.tableSpace;
        return Text.replace(sql, TABLE_SPACE_VARIABLE, tspace).trim();
    }

    protected void prepareSchemaObjectPrefix() throws Exception {
        DatabaseMetaData metaData = this.connectionManager.getConnection().getMetaData();
        String legalChars = metaData.getExtraNameCharacters();
        legalChars = legalChars + "ABCDEFGHIJKLMNOPQRSTUVWXZY0123456789_";
        String prefix = this.schemaObjectPrefix.toUpperCase();
        StringBuffer escaped = new StringBuffer();
        for (int i = 0; i < prefix.length(); ++i) {
            char c = prefix.charAt(i);
            if (legalChars.indexOf(c) == -1) {
                escaped.append('_');
                continue;
            }
            escaped.append(c);
        }
        this.schemaObjectPrefix = escaped.toString();
    }
}

