/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.jndi;

import java.util.Hashtable;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.core.jndi.BindableRepositoryFactory;

public class RegistryHelper {
    private RegistryHelper() {
    }

    public static void registerRepository(Context ctx, String name, String configFilePath, String repHomeDir, boolean overwrite) throws NamingException, RepositoryException {
        Reference reference = new Reference(Repository.class.getName(), BindableRepositoryFactory.class.getName(), null);
        reference.add(new StringRefAddr("configFilePath", configFilePath));
        reference.add(new StringRefAddr("repHomeDir", repHomeDir));
        Object obj = new BindableRepositoryFactory().getObjectInstance((Object)reference, (Name)null, (Context)null, (Hashtable)null);
        if (overwrite) {
            ctx.rebind(name, obj);
        } else {
            ctx.bind(name, obj);
        }
    }

    public static void unregisterRepository(Context ctx, String name) throws NamingException {
        ((JackrabbitRepository)ctx.lookup(name)).shutdown();
        ctx.unbind(name);
    }
}

