/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.prototype.MicrosoftCodeAnalyzerPlugin;

import generic.jar.ResourceFile;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.script.GhidraScript;
import ghidra.app.script.GhidraScriptProvider;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.app.script.GhidraState;
import ghidra.app.script.ScriptInfo;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.services.ConsoleService;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.Project;
import ghidra.framework.options.Options;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.PrintWriter;

public class WindowsResourceReferenceAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "WindowsResourceReference";
    private static final String DESCRIPTION = "Given certain Key windows API calls, tries to create references at the use of windows Resources.";
    boolean scriptWasFound = false;
    private static final String OPTION_NAME_CREATE_BOOKMARKS = "Create Analysis Bookmarks";
    private static final String OPTION_DESCRIPTION_CREATE_BOOKMARKS = "Select this check box if you want this analyzer to create analysis bookmarks when items of interest are created/identified by the analyzer.";
    private static final boolean OPTION_DEFAULT_CREATE_BOOKMARKS_ENABLED = true;
    private boolean createBookmarksEnabled = true;

    public WindowsResourceReferenceAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.INSTRUCTION_ANALYZER);
        this.setSupportsOneTimeAnalysis();
        this.setPriority(AnalysisPriority.DATA_TYPE_PROPOGATION);
        this.setDefaultEnablement(true);
    }

    public boolean canAnalyze(Program program) {
        String format = program.getExecutableFormat();
        return format.equals("Portable Executable (PE)");
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        this.runScript(program, set, "WindowsResourceReference.java", monitor);
        return true;
    }

    public boolean runScript(Program program, AddressSetView set, String scriptName, TaskMonitor monitor) {
        AutoAnalysisManager analysisManager = AutoAnalysisManager.getAnalysisManager((Program)program);
        PluginTool tool = analysisManager.getAnalysisTool();
        Project project = this.findProject(tool);
        GhidraState state = new GhidraState(tool, project, program, new ProgramLocation(program, set.getMinAddress()), new ProgramSelection(set), null);
        try {
            ScriptInfo scriptInfo = GhidraScriptUtil.findScriptByName((String)scriptName);
            if (scriptInfo == null) {
                throw new IllegalAccessException("Couldn't find script");
            }
            GhidraScriptProvider provider = GhidraScriptUtil.getProvider((ResourceFile)scriptInfo.getSourceFile());
            if (provider == null) {
                throw new IllegalAccessException("Couldn't find script provider");
            }
            PrintWriter writer = this.getOutputMsgStream(tool);
            GhidraScript script = provider.getScriptInstance(scriptInfo.getSourceFile(), writer);
            script.set(state, monitor, writer);
            String[] scriptArguments = new String[]{"false", String.valueOf(this.createBookmarksEnabled)};
            script.runScript(scriptName, scriptArguments);
            return true;
        }
        catch (IllegalAccessException e) {
            Msg.warn((Object)((Object)this), (Object)("Unable to access script: " + scriptName), (Throwable)e);
        }
        catch (InstantiationException e) {
            Msg.warn((Object)((Object)this), (Object)("Unable to instantiate script: " + scriptName), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            Msg.warn((Object)((Object)this), (Object)("Unable to locate script class: " + e.getMessage()), (Throwable)e);
        }
        catch (CancelledException e) {
            Msg.warn((Object)((Object)this), (Object)"User cancelled script.", (Throwable)e);
        }
        catch (Exception e) {
            Msg.warn((Object)("Error running script: " + scriptName + "\n" + e.getMessage()), (Object)e);
            e.printStackTrace();
        }
        return false;
    }

    private Project findProject(PluginTool tool) {
        if (tool != null) {
            return tool.getProject();
        }
        return null;
    }

    private PrintWriter getOutputMsgStream(PluginTool tool) {
        ConsoleService console;
        if (tool != null && (console = (ConsoleService)tool.getService(ConsoleService.class)) != null) {
            return console.getStdOut();
        }
        return new PrintWriter(System.out);
    }

    public boolean removed(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        return false;
    }

    public void registerOptions(Options options, Program program) {
        options.registerOption(OPTION_NAME_CREATE_BOOKMARKS, (Object)this.createBookmarksEnabled, null, OPTION_DESCRIPTION_CREATE_BOOKMARKS);
    }

    public void optionsChanged(Options options, Program program) {
        this.createBookmarksEnabled = options.getBoolean(OPTION_NAME_CREATE_BOOKMARKS, this.createBookmarksEnabled);
    }
}

