/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.ASTGraphTask;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.services.GraphService;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.HighFunction;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;

public class GraphASTControlFlowAction
extends AbstractDecompilerAction {
    private final DecompilerController controller;
    private final PluginTool tool;

    public GraphASTControlFlowAction(Plugin plugin, DecompilerController controller) {
        super("Graph AST Control Flow");
        this.tool = plugin.getTool();
        this.controller = controller;
        this.setMenuBarData(new MenuData(new String[]{"Graph AST Control Flow"}, "graph"));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        return this.controller.getFunction() != null;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        GraphService graphService = (GraphService)this.tool.getService(GraphService.class);
        if (graphService == null) {
            Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"AST Graph Failed", (Object)"GraphService not found: Please add a graph service provider to your tool");
            return;
        }
        ToolOptions options = this.tool.getOptions("Graph");
        boolean reuseGraph = options.getBoolean("Reuse Graph", false);
        int codeLimitPerBlock = options.getInt("Max Code Lines Displayed", 10);
        HighFunction highFunction = this.controller.getHighFunction();
        Address locationAddr = this.controller.getLocation().getAddress();
        ASTGraphTask task = new ASTGraphTask(graphService, !reuseGraph, codeLimitPerBlock, locationAddr, highFunction, 0);
        new TaskLauncher((Task)task, (Component)this.tool.getToolFrame());
    }
}

