/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangFunction;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.xml.XmlPullParser;

public abstract class ClangXML {
    public static final String DOCUMENT = "clang_document";
    public static final String FUNCTION = "function";
    public static final String BLOCK = "block";
    public static final String RETURN_TYPE = "return_type";
    public static final String VARDECL = "vardecl";
    public static final String STATEMENT = "statement";
    public static final String FUNCPROTO = "funcproto";
    public static final String SYNTAX = "syntax";
    public static final String BREAK = "break";
    public static final String VARIABLE = "variable";
    public static final String OP = "op";
    public static final String FUNCNAME = "funcname";
    public static final String TYPE = "type";
    public static final String FIELD = "field";
    public static final String COMMENT = "comment";
    public static final String LABEL = "label";
    public static final String INDENT = "indent";
    public static final String COLOR = "color";
    public static final String OPREF = "opref";
    public static final String BLOCKREF = "blockref";
    public static final String VARNODEREF = "varref";
    public static final String SPACE = "space";
    public static final String OFFSET = "off";
    public static final String PCSPACE = "pcspace";
    public static final String PCOFFSET = "pcoff";
    public static final String SYMREF = "symref";
    public static final String KEYWORD_COLOR = "keyword";
    public static final String COMMENT_COLOR = "comment";
    public static final String TYPE_COLOR = "type";
    public static final String FUNCNAME_COLOR = "funcname";
    public static final String VARIABLE_COLOR = "var";
    public static final String CONST_COLOR = "const";
    public static final String PARAMETER_COLOR = "param";
    public static final String GLOBAL_COLOR = "global";

    public static ClangTokenGroup buildClangTree(XmlPullParser parser, HighFunction hfunc) {
        ClangTokenGroup docroot = parser.peek().getName().equals(FUNCTION) ? new ClangFunction(null, hfunc) : new ClangTokenGroup(null);
        docroot.restoreFromXML(parser, (PcodeFactory)hfunc);
        return docroot;
    }
}

