/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.util.Msg;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class ClangVariableDecl
extends ClangTokenGroup {
    private DataType datatype = null;
    private HighVariable typevar = null;

    public ClangVariableDecl(ClangNode par) {
        super(par);
    }

    public DataType getDataType() {
        return this.datatype;
    }

    public HighVariable getHighVariable() {
        return this.typevar;
    }

    @Override
    public void restoreFromXML(XmlPullParser parser, PcodeFactory pfactory) {
        XmlElement node = parser.peek();
        super.restoreFromXML(parser, pfactory);
        int symref = SpecXmlUtils.decodeInt((String)node.getAttribute("symref"));
        HighSymbol sym = pfactory.getSymbol(symref);
        if (sym == null) {
            Msg.error((Object)this, (Object)("Invalid symbol reference: " + symref));
            return;
        }
        this.typevar = sym.getHighVariable();
        this.datatype = sym.getDataType();
        if (this.typevar == null) {
            Msg.error((Object)this, (Object)("High variable not found: " + sym.getName()));
            return;
        }
    }
}

