/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.bitpatterns.gui.ByteSequenceTableModel;
import ghidra.bitpatterns.gui.FunctionBitPatternsExplorerPlugin;
import ghidra.bitpatterns.info.ByteSequenceRowObject;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.List;

public class DisassembledByteSequenceTableModel
extends ByteSequenceTableModel {
    public DisassembledByteSequenceTableModel(FunctionBitPatternsExplorerPlugin plugin, List<ByteSequenceRowObject> rowObjects) {
        super(plugin, rowObjects);
        this.rowObjects = rowObjects;
    }

    @Override
    protected void doLoad(Accumulator<ByteSequenceRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.rowObjects != null) {
            accumulator.addAll((Collection)this.rowObjects);
        }
    }

    @Override
    protected TableColumnDescriptor<ByteSequenceRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new ByteSequenceTableModel.ByteSequenceTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ByteSequenceDisassemblyTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ByteSequenceTableModel.ByteSequenceNumOccurrencesTableColumn(), 0, false);
        descriptor.addVisibleColumn((DynamicTableColumn)new ByteSequenceTableModel.ByteSequencePercentageTableColumn());
        return descriptor;
    }

    private class ByteSequenceDisassemblyTableColumn
    extends AbstractDynamicTableColumn<ByteSequenceRowObject, String, Object> {
        private ByteSequenceDisassemblyTableColumn() {
        }

        public String getColumnName() {
            return "Disassembly";
        }

        public String getValue(ByteSequenceRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getDisassembly();
        }

        public GColumnRenderer<String> getColumnRenderer() {
            return DisassembledByteSequenceTableModel.this.monospacedRenderer;
        }
    }
}

