(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/srfi/151#bitwise-nand
    (lambda (_i570_ _j571_) (bitwise-not (bitwise-and _i570_ _j571_))))
  (define std/srfi/151#bitwise-nor
    (lambda (_i567_ _j568_) (bitwise-not (bitwise-ior _i567_ _j568_))))
  (define std/srfi/151#bitwise-andc1
    (lambda (_i564_ _j565_) (bitwise-and (bitwise-not _i564_) _j565_)))
  (define std/srfi/151#bitwise-andc2
    (lambda (_i561_ _j562_) (bitwise-and _i561_ (bitwise-not _j562_))))
  (define std/srfi/151#bitwise-orc1
    (lambda (_i558_ _j559_) (bitwise-ior (bitwise-not _i558_) _j559_)))
  (define std/srfi/151#bitwise-orc2
    (lambda (_i555_ _j556_) (bitwise-ior _i555_ (bitwise-not _j556_))))
  (define std/srfi/151#bitwise-eqv
    (lambda _args548_
      (let _lp550_ ((_args552_ _args548_) (_ans553_ '-1))
        (if (pair? _args552_)
            (_lp550_ (cdr _args552_)
                     (bitwise-not (bitwise-xor _ans553_ (car _args552_))))
            _ans553_))))
  (define std/srfi/151#mask
    (lambda (_start545_ _end546_)
      (bitwise-not (arithmetic-shift '-1 (- _end546_ _start545_)))))
  (define std/srfi/151#any-bit-set?
    (lambda (_test-bits542_ _n543_)
      (not (zero? (bitwise-and _test-bits542_ _n543_)))))
  (define std/srfi/151#every-bit-set?
    (lambda (_test-bits539_ _n540_)
      (= _test-bits539_ (bitwise-and _test-bits539_ _n540_))))
  (define std/srfi/151#bit-field
    (lambda (_n535_ _start536_ _end537_)
      (bitwise-and
       (std/srfi/151#mask _start536_ _end537_)
       (arithmetic-shift _n535_ (- _start536_)))))
  (define std/srfi/151#bit-field-any?
    (lambda (_n531_ _start532_ _end533_)
      (not (zero? (bitwise-and
                   (arithmetic-shift _n531_ (- _start532_))
                   (std/srfi/151#mask _start532_ _end533_))))))
  (define std/srfi/151#bit-field-every?
    (lambda (_n525_ _start526_ _end527_)
      (let ((_m529_ (std/srfi/151#mask _start526_ _end527_)))
        (eqv? _m529_
              (bitwise-and (arithmetic-shift _n525_ (- _start526_)) _m529_)))))
  (define std/srfi/151#bit-field-clear
    (lambda (_n521_ _start522_ _end523_)
      (std/srfi/151#bit-field-replace _n521_ '0 _start522_ _end523_)))
  (define std/srfi/151#bit-field-set
    (lambda (_n517_ _start518_ _end519_)
      (std/srfi/151#bit-field-replace _n517_ '-1 _start518_ _end519_)))
  (define std/srfi/151#bit-field-replace
    (lambda (_n510_ _newfield511_ _start512_ _end513_)
      (let ((_m515_ (std/srfi/151#mask _start512_ _end513_)))
        (bitwise-ior
         (bitwise-and
          _n510_
          (bitwise-not (arithmetic-shift _m515_ _start512_)))
         (arithmetic-shift (bitwise-and _newfield511_ _m515_) _start512_)))))
  (define std/srfi/151#bit-field-replace-same
    (lambda (_to505_ _from506_ _start507_ _end508_)
      (std/srfi/151#bitwise-if
       (arithmetic-shift (std/srfi/151#mask _start507_ _end508_) _start507_)
       _from506_
       _to505_)))
  (define std/srfi/151#first-set-bit
    (lambda (_i503_) (- (bit-count (bitwise-xor _i503_ (- _i503_ '1))) '1)))
  (define std/srfi/151#bit-field-rotate
    (lambda (_n492_ _count493_ _start494_ _end495_)
      (letrec* ((_width497_ (- _end495_ _start494_)))
        (set! _count493_ (modulo _count493_ _width497_))
        (let ((_mask499_ (bitwise-not (arithmetic-shift '-1 _width497_))))
          (letrec* ((_zn501_ (bitwise-and
                              _mask499_
                              (arithmetic-shift _n492_ (- _start494_)))))
            (bitwise-ior
             (arithmetic-shift
              (bitwise-ior
               (bitwise-and _mask499_ (arithmetic-shift _zn501_ _count493_))
               (arithmetic-shift _zn501_ (- _count493_ _width497_)))
              _start494_)
             (bitwise-and
              (bitwise-not (arithmetic-shift _mask499_ _start494_))
              _n492_)))))))
  (define std/srfi/151#bit-reverse
    (lambda (_k482_ _n483_)
      (let _$loop485_ ((_m488_ (if (negative? _n483_)
                                   (bitwise-not _n483_)
                                   _n483_))
                       (_k489_ (+ '-1 _k482_))
                       (_rvs490_ '0))
        (if (negative? _k489_)
            (if (negative? _n483_) (bitwise-not _rvs490_) _rvs490_)
            (_$loop485_
             (arithmetic-shift _m488_ '-1)
             (+ '-1 _k489_)
             (bitwise-ior
              (arithmetic-shift _rvs490_ '1)
              (bitwise-and '1 _m488_)))))))
  (define std/srfi/151#bit-field-reverse
    (lambda (_n472_ _start473_ _end474_)
      (letrec* ((_width476_ (- _end474_ _start473_)))
        (let ((_mask478_ (bitwise-not (arithmetic-shift '-1 _width476_))))
          (letrec* ((_zn480_ (bitwise-and
                              _mask478_
                              (arithmetic-shift _n472_ (- _start473_)))))
            (bitwise-ior
             (arithmetic-shift
              (std/srfi/151#bit-reverse _width476_ _zn480_)
              _start473_)
             (bitwise-and
              (bitwise-not (arithmetic-shift _mask478_ _start473_))
              _n472_)))))))
  (define std/srfi/151#copy-bit
    (lambda (_index468_ _to469_ _bool470_)
      (if _bool470_
          (bitwise-ior _to469_ (arithmetic-shift '1 _index468_))
          (bitwise-and
           _to469_
           (bitwise-not (arithmetic-shift '1 _index468_))))))
  (define std/srfi/151#bits->list
    (lambda (_k452_ . _len453_)
      (if (null? _len453_)
          (let _$loop455_ ((_k458_ _k452_) (_lst459_ '()))
            (if (<= _k458_ '0)
                (reverse _lst459_)
                (_$loop455_
                 (arithmetic-shift _k458_ '-1)
                 (cons (odd? _k458_) _lst459_))))
          (let _$loop461_ ((_idx464_ (+ '-1 (car _len453_)))
                           (_k465_ _k452_)
                           (_lst466_ '()))
            (if (negative? _idx464_)
                (reverse _lst466_)
                (_$loop461_
                 (+ '-1 _idx464_)
                 (arithmetic-shift _k465_ '-1)
                 (cons (odd? _k465_) _lst466_)))))))
  (define std/srfi/151#list->bits
    (lambda (_bools444_)
      (let _$loop446_ ((_bs449_ (reverse _bools444_)) (_acc450_ '0))
        (if (null? _bs449_)
            _acc450_
            (_$loop446_
             (cdr _bs449_)
             (+ _acc450_ _acc450_ (if (car _bs449_) '1 '0)))))))
  (define std/srfi/151#bits
    (lambda _bools442_ (std/srfi/151#list->bits _bools442_)))
  (define std/srfi/151#bitwise-if
    (lambda (_mask438_ _n0439_ _n1440_)
      (bitwise-ior
       (bitwise-and _mask438_ _n0439_)
       (bitwise-and (bitwise-not _mask438_) _n1440_))))
  (define std/srfi/151#bits->vector__0
    (lambda (_i433_) (list->vector (std/srfi/151#bits->list _i433_))))
  (define std/srfi/151#bits->vector__1
    (lambda (_i435_ _len436_)
      (list->vector (std/srfi/151#bits->list _i435_ _len436_))))
  (define std/srfi/151#bits->vector
    (lambda _g4172_
      (let ((_g4171_ (let () (declare (not safe)) (##length _g4172_))))
        (cond ((let () (declare (not safe)) (##fx= _g4171_ 1))
               (apply std/srfi/151#bits->vector__0 _g4172_))
              ((let () (declare (not safe)) (##fx= _g4171_ 2))
               (apply std/srfi/151#bits->vector__1 _g4172_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/srfi/151#bits->vector
                _g4172_))))))
  (define std/srfi/151#vector->bits
    (lambda (_vector431_)
      (std/srfi/151#list->bits (vector->list _vector431_))))
  (define std/srfi/151#bit-swap
    (lambda (_n1424_ _n2425_ _i426_)
      (let ((_n1-bit428_ (bit-set? _n1424_ _i426_))
            (_n2-bit429_ (bit-set? _n2425_ _i426_)))
        (std/srfi/151#copy-bit
         _n2425_
         (std/srfi/151#copy-bit _n1424_ _i426_ _n2-bit429_)
         _n1-bit428_))))
  (define std/srfi/151#bitwise-fold
    (lambda (_proc413_ _seed414_ _i415_)
      (let ((_len417_ (integer-length _i415_)))
        (let _loop419_ ((_n421_ '0) (_r422_ _seed414_))
          (if (= _n421_ _len417_)
              _r422_
              (_loop419_
               (+ _n421_ '1)
               (_proc413_ (bit-set? _n421_ _i415_) _r422_)))))))
  (define std/srfi/151#bitwise-for-each
    (lambda (_proc404_ _i405_)
      (let ((_len407_ (integer-length _i405_)))
        (let _loop409_ ((_n411_ '0))
          (if (< _n411_ _len407_)
              (begin
                (_proc404_ (bit-set? _n411_ _i405_))
                (_loop409_ (+ _n411_ '1)))
              '#!void)))))
  (define std/srfi/151#bitwise-unfold
    (lambda (_stop?393_ _mapper394_ _successor395_ _seed396_)
      (let _loop398_ ((_n400_ '0) (_result401_ '0) (_state402_ _seed396_))
        (if (_stop?393_ _state402_)
            _result401_
            (_loop398_
             (+ _n400_ '1)
             (std/srfi/151#copy-bit
              _n400_
              _result401_
              (_mapper394_ _state402_))
             (_successor395_ _state402_))))))
  (define std/srfi/151#make-bitwise-generator
    (lambda (_i388_)
      (lambda ()
        (let ((_bit391_ (bit-set? '0 _i388_)))
          (set! _i388_ (arithmetic-shift _i388_ '-1))
          _bit391_)))))
