#!/usr/bin/env python3
# encoding: utf-8

"""
A script that autogenerates some information about campaigns for the
CampaignInformation wiki page. The script is a WIP.
"""

import os.path, sys
import argparse

import wesnoth.wmlparser3 as wmlparser3


class Campaign:
    """
    A class for a specific campaign.
    """
    def __init__(self, parser):
        self.parser = parser
        self.name = self.parser.get_text_val("name")
        self.id = self.parser.get_text_val("id")
        self.description = self.parser.get_text_val("description")
        self.levels = len(self.parser.get_all(tag="difficulty"))
        self.credits_link = "https://wiki.wesnoth.org/Credits#" + self.id
        self.units_link = "http://units.wesnoth.org/trunk/mainline/en_US/%s.html" % self.id

def wiki_output(campaign):
    """
    Takes a campaign instance and outputs information in wiki format
    """
    # Remove Espreon fancy but bug-inducing characters
    for char in ("’", "—", '‘'):
        campaign.name = campaign.name.replace(char, "")
        campaign.description = campaign.description.replace(char, "")
    text = """== {0} ==
{1}

Difficulty levels : {2}
* [{3} Custom units]
* [{4} Credits]
""".format(campaign.name, campaign.description, campaign.levels,
campaign.units_link, campaign.credits_link)
    return text


if __name__ == "__main__":
    # Possible arguments
    arg_parser = argparse.ArgumentParser(description='campaign2wiki is a script\
which generates information about campaigns for the wiki.')
    arg_parser.add_argument('-d', '--data', default='data/',
        dest='data_dir', help="The location of wesnoth data directory")
    arg_parser.add_argument('-o', '--output', default='/tmp/CampaignWML',
        dest='output_path', help="The location of the output file.")
    arg_parser.add_argument('-w', '--wesnoth', default='./wesnoth',
        dest='wesnoth', help='The wesnoth executable location')
    args = arg_parser.parse_args()

    output = ['{{Autogenerated}} ']
    main = wmlparser3.Parser(args.wesnoth, None, None)
    main.parse_file('data/_main.cfg')
    for campaign in main.get_all(tag='campaign'):
        a = Campaign(campaign)
        output.append(wiki_output(a))

    with open(args.output_path, "w", encoding="utf8") as wiki_format:
        wiki_format.write(''.join(output))
