/*
 * Decompiled with CFR 0.152.
 */
package tr.view.future.filters;

import ca.odell.glazedlists.matchers.Matcher;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Date;
import org.openide.util.NbBundle;
import tr.model.future.Future;
import tr.swing.date.combo.DateItem;
import tr.util.DateUtils;
import tr.view.filters.FilterComboDate;
import tr.view.future.filters.MatcherEditorBase;

public class MatcherEditorCreatedTo
extends MatcherEditorBase
implements PropertyChangeListener {
    private static final DateItem[] dateItems = new DateItem[]{DateItem.DATE_CHOOSER, DateItem.TODAY, DateItem.YESTERDAY, DateItem.WEEKS_AGO_1, DateItem.WEEKS_AGO_2, DateItem.WEEKS_AGO_3, DateItem.WEEKS_AGO_4};
    private final FilterComboDate dateCombo = new FilterComboDate(dateItems, false);

    public MatcherEditorCreatedTo() {
        this.dateCombo.addValueChangeListener((PropertyChangeListener)this);
    }

    public Component getComponent() {
        return this.dateCombo;
    }

    public void propertyChange(PropertyChangeEvent e) {
        DateItem item = (DateItem)this.dateCombo.getSelectedItem();
        if (item == null) {
            this.fireMatchAll();
        } else {
            this.fireChanged(new ToDateMatcher(FilterComboDate.getDate((DateItem)item)));
        }
    }

    public String getLabel() {
        return NbBundle.getMessage(this.getClass(), (String)"filter-created-to");
    }

    public Serializable getSerializable() {
        return (DateItem)this.dateCombo.getSelectedItem();
    }

    public void setSerializable(Serializable serializable) {
        if (serializable == null || serializable instanceof DateItem) {
            this.dateCombo.setSelectedItem((Object)serializable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ToDateMatcher
    implements Matcher<Future> {
        private final Date date;

        public ToDateMatcher() {
            this.date = null;
        }

        public ToDateMatcher(Date date) {
            this.date = DateUtils.getEnd((Date)date);
        }

        public boolean matches(Future future) {
            return this.date == null || !future.getCreated().after(this.date);
        }
    }
}

