/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.masterfs.filebasedfs.utils.FSException;
import org.openide.util.WeakSet;

public final class MutualExclusionSupport {
    private static final MutualExclusionSupport DEFAULT = new MutualExclusionSupport();
    private static final Map exclusive = Collections.synchronizedMap(new WeakHashMap());
    private static final Map shared = Collections.synchronizedMap(new WeakHashMap());

    public static MutualExclusionSupport getDefault() {
        return DEFAULT;
    }

    private MutualExclusionSupport() {
    }

    public synchronized Closeable addResource(Object object, boolean bl) throws IOException {
        boolean bl2 = true;
        Map map = bl ? exclusive : shared;
        Map map2 = bl ? shared : exclusive;
        WeakSet weakSet = (WeakSet)map.get(object);
        WeakSet weakSet2 = (WeakSet)map2.get(object);
        for (int i = 0; i < 10 && bl2; ++i) {
            boolean bl3 = bl2 = weakSet != null && weakSet.size() > 0;
            if (!bl2) {
                if (weakSet2 == null) {
                    weakSet2 = new WeakSet();
                    map2.put(object, weakSet2);
                }
                boolean bl4 = bl2 = !bl && weakSet2.size() > 0;
            }
            if (!bl2) continue;
            try {
                this.wait(200L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        if (bl2) {
            if (bl) {
                FSException.io("EXC_CannotGetSharedAccess", object.toString());
            } else {
                FSException.io("EXC_CannotGetExclusiveAccess", object.toString());
            }
        }
        Closeable closeable = new Closeable(object, bl);
        weakSet2.add((Object)closeable);
        return closeable;
    }

    private synchronized void removeResource(Object object, Object object2, boolean bl) {
        Map map = bl ? shared : exclusive;
        WeakSet weakSet = (WeakSet)map.get(object);
        if (weakSet != null) {
            weakSet.remove(object2);
        }
    }

    public final class Closeable {
        private final boolean isShared;
        private final Reference keyRef;
        private boolean isClosed = false;

        private Closeable(Object object, boolean bl) {
            this.isShared = bl;
            this.keyRef = new WeakReference<Object>(object);
        }

        public final void close() {
            if (!this.isClosed()) {
                this.isClosed = true;
                Object t = this.keyRef.get();
                if (t != null) {
                    MutualExclusionSupport.this.removeResource(t, this, this.isShared);
                }
            }
        }

        public final boolean isClosed() {
            return this.isClosed;
        }
    }
}

