/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.lexer;

import com.intellij.lexer.LexerBase;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeKt;
import org.intellij.markdown.ast.visitors.RecursiveVisitor;
import org.intellij.markdown.ast.visitors.Visitor;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.plugins.markdown.lang.MarkdownElementType;
import org.intellij.plugins.markdown.lang.parser.MarkdownParserManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownToplevelLexer
extends LexerBase {
    private CharSequence myBuffer;
    private int myBufferStart;
    private int myBufferEnd;
    private List<IElementType> myLexemes;
    private List<Integer> myStartOffsets;
    private List<Integer> myEndOffsets;
    private int myLexemeIndex;
    @NotNull
    final MarkdownFlavourDescriptor myFlavour;

    public MarkdownToplevelLexer() {
        this((MarkdownFlavourDescriptor)MarkdownParserManager.FLAVOUR);
    }

    public MarkdownToplevelLexer(@NotNull MarkdownFlavourDescriptor flavour) {
        if (flavour == null) {
            MarkdownToplevelLexer.$$$reportNull$$$0(0);
        }
        this.myFlavour = flavour;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            MarkdownToplevelLexer.$$$reportNull$$$0(1);
        }
        this.myBuffer = buffer;
        this.myBufferStart = startOffset;
        this.myBufferEnd = endOffset;
        ASTNode parsedTree = MarkdownParserManager.parseContent(buffer.subSequence(startOffset, endOffset), this.myFlavour);
        this.myLexemes = new ArrayList<IElementType>();
        this.myStartOffsets = new ArrayList<Integer>();
        this.myEndOffsets = new ArrayList<Integer>();
        ASTNodeKt.accept((ASTNode)parsedTree, (Visitor)new LexerBuildingVisitor());
        this.myLexemeIndex = 0;
    }

    public int getState() {
        return this.myLexemeIndex;
    }

    @Nullable
    public IElementType getTokenType() {
        if (this.myLexemeIndex >= this.myLexemes.size()) {
            return null;
        }
        return this.myLexemes.get(this.myLexemeIndex);
    }

    public int getTokenStart() {
        if (this.myLexemeIndex >= this.myLexemes.size()) {
            return this.myBufferEnd;
        }
        return this.myBufferStart + this.myStartOffsets.get(this.myLexemeIndex);
    }

    public int getTokenEnd() {
        if (this.myLexemeIndex >= this.myLexemes.size()) {
            return this.myBufferEnd;
        }
        return this.myBufferStart + this.myEndOffsets.get(this.myLexemeIndex);
    }

    public void advance() {
        ++this.myLexemeIndex;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            MarkdownToplevelLexer.$$$reportNull$$$0(2);
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavour";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/lang/lexer/MarkdownToplevelLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/lang/lexer/MarkdownToplevelLexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LexerBuildingVisitor
    extends RecursiveVisitor {
        private LexerBuildingVisitor() {
        }

        public void visitNode(@NotNull ASTNode node) {
            if (node == null) {
                LexerBuildingVisitor.$$$reportNull$$$0(0);
            }
            if (node.getStartOffset() == node.getEndOffset()) {
                return;
            }
            List children2 = node.getChildren();
            if (children2.isEmpty()) {
                MarkdownToplevelLexer.this.myLexemes.add(MarkdownElementType.platformType(node.getType()));
                MarkdownToplevelLexer.this.myStartOffsets.add(node.getStartOffset());
                MarkdownToplevelLexer.this.myEndOffsets.add(node.getEndOffset());
            } else {
                super.visitNode(node);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/intellij/plugins/markdown/lang/lexer/MarkdownToplevelLexer$LexerBuildingVisitor", "visitNode"));
        }
    }
}

