/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.TextEditor;
import org.jetbrains.annotations.NotNull;

public class TextEditorLocation
implements FileEditorLocation {
    private static final Logger LOG = Logger.getInstance(TextEditorLocation.class);
    private final TextEditor myEditor;
    private final LogicalPosition myPosition;

    public TextEditorLocation(int offset, @NotNull TextEditor editor) {
        if (editor == null) {
            TextEditorLocation.$$$reportNull$$$0(0);
        }
        this(editor.getEditor().offsetToLogicalPosition(offset), editor);
    }

    public TextEditorLocation(@NotNull LogicalPosition position, @NotNull TextEditor editor) {
        if (position == null) {
            TextEditorLocation.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            TextEditorLocation.$$$reportNull$$$0(2);
        }
        this.myEditor = editor;
        this.myPosition = position;
    }

    @Override
    @NotNull
    public FileEditor getEditor() {
        TextEditor textEditor = this.myEditor;
        if (textEditor == null) {
            TextEditorLocation.$$$reportNull$$$0(3);
        }
        return textEditor;
    }

    @NotNull
    public LogicalPosition getPosition() {
        LogicalPosition logicalPosition = this.myPosition;
        if (logicalPosition == null) {
            TextEditorLocation.$$$reportNull$$$0(4);
        }
        return logicalPosition;
    }

    @Override
    public int compareTo(@NotNull FileEditorLocation fileEditorLocation) {
        if (fileEditorLocation == null) {
            TextEditorLocation.$$$reportNull$$$0(5);
        }
        TextEditorLocation otherLocation = (TextEditorLocation)fileEditorLocation;
        if (this.myEditor != otherLocation.myEditor) {
            LOG.error("Different editors: " + this.myEditor + "; and " + otherLocation.myEditor);
        }
        return this.myPosition.compareTo(otherLocation.myPosition);
    }

    public String toString() {
        return this.myPosition.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/TextEditorLocation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/TextEditorLocation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

