/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Point;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface InlayModel {
    @Nullable
    default public <T extends EditorCustomElementRenderer> Inlay<T> addInlineElement(int offset, @NotNull T renderer) {
        if (renderer == null) {
            InlayModel.$$$reportNull$$$0(0);
        }
        return this.addInlineElement(offset, false, renderer);
    }

    @Nullable
    public <T extends EditorCustomElementRenderer> Inlay<T> addInlineElement(int var1, boolean var2, @NotNull T var3);

    @Nullable
    public <T extends EditorCustomElementRenderer> Inlay<T> addInlineElement(int var1, boolean var2, int var3, @NotNull T var4);

    @Nullable
    public <T extends EditorCustomElementRenderer> Inlay<T> addBlockElement(int var1, boolean var2, boolean var3, int var4, @NotNull T var5);

    @Nullable
    public <T extends EditorCustomElementRenderer> Inlay<T> addAfterLineEndElement(int var1, boolean var2, @NotNull T var3);

    @NotNull
    public List<Inlay<?>> getInlineElementsInRange(int var1, int var2);

    default public <T> List<Inlay<? extends T>> getInlineElementsInRange(int startOffset, int endOffset, @NotNull Class<T> type) {
        if (type == null) {
            InlayModel.$$$reportNull$$$0(1);
        }
        return ContainerUtil.filter(this.getInlineElementsInRange(startOffset, endOffset), inlay -> type.isInstance(inlay.getRenderer()));
    }

    @NotNull
    public List<Inlay<?>> getBlockElementsInRange(int var1, int var2);

    default public <T> List<Inlay<? extends T>> getBlockElementsInRange(int startOffset, int endOffset, @NotNull Class<T> type) {
        if (type == null) {
            InlayModel.$$$reportNull$$$0(2);
        }
        return ContainerUtil.filter(this.getBlockElementsInRange(startOffset, endOffset), inlay -> type.isInstance(inlay.getRenderer()));
    }

    @NotNull
    public List<Inlay<?>> getBlockElementsForVisualLine(int var1, boolean var2);

    default public boolean hasBlockElements() {
        return !this.getBlockElementsInRange(0, Integer.MAX_VALUE).isEmpty();
    }

    default public boolean hasInlineElementsInRange(int startOffset, int endOffset) {
        return !this.getInlineElementsInRange(startOffset, endOffset).isEmpty();
    }

    default public boolean hasInlineElements() {
        return this.hasInlineElementsInRange(0, Integer.MAX_VALUE);
    }

    public boolean hasInlineElementAt(int var1);

    default public boolean hasInlineElementAt(@NotNull VisualPosition visualPosition) {
        if (visualPosition == null) {
            InlayModel.$$$reportNull$$$0(3);
        }
        return this.getInlineElementAt(visualPosition) != null;
    }

    @Nullable
    public Inlay getInlineElementAt(@NotNull VisualPosition var1);

    @Nullable
    public Inlay getElementAt(@NotNull Point var1);

    @Nullable
    default public <T> Inlay<? extends T> getElementAt(@NotNull Point point, @NotNull Class<T> type) {
        Inlay inlay;
        if (point == null) {
            InlayModel.$$$reportNull$$$0(4);
        }
        if (type == null) {
            InlayModel.$$$reportNull$$$0(5);
        }
        return (inlay = this.getElementAt(point)) != null && type.isInstance(inlay.getRenderer()) ? inlay : null;
    }

    @NotNull
    public List<Inlay<?>> getAfterLineEndElementsInRange(int var1, int var2);

    @NotNull
    default public <T> List<Inlay<? extends T>> getAfterLineEndElementsInRange(int startOffset, int endOffset, @NotNull Class<T> type) {
        if (type == null) {
            InlayModel.$$$reportNull$$$0(6);
        }
        List list = ContainerUtil.filter(this.getAfterLineEndElementsInRange(startOffset, endOffset), inlay -> type.isInstance(inlay.getRenderer()));
        if (list == null) {
            InlayModel.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public List<Inlay<?>> getAfterLineEndElementsForLogicalLine(int var1);

    public void setConsiderCaretPositionOnDocumentUpdates(boolean var1);

    public void execute(boolean var1, @NotNull Runnable var2);

    public boolean isInBatchMode();

    public void addListener(@NotNull Listener var1, @NotNull Disposable var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visualPosition";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/InlayModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/InlayModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterLineEndElementsInRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addInlineElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInlineElementsInRange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBlockElementsInRange";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasInlineElementAt";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementAt";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAfterLineEndElementsInRange";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ChangeFlags {
        public static final int WIDTH_CHANGED = 1;
        public static final int HEIGHT_CHANGED = 2;
        public static final int GUTTER_ICON_PROVIDER_CHANGED = 4;
    }

    public static abstract class SimpleAdapter
    implements Listener {
        public void onAdded(@NotNull Inlay inlay) {
            if (inlay == null) {
                SimpleAdapter.$$$reportNull$$$0(0);
            }
            this.onUpdated(inlay, 3 | (inlay.getGutterIconRenderer() == null ? 0 : 4));
        }

        public void onRemoved(@NotNull Inlay inlay) {
            if (inlay == null) {
                SimpleAdapter.$$$reportNull$$$0(1);
            }
            this.onUpdated(inlay, 3 | (inlay.getGutterIconRenderer() == null ? 0 : 4));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "inlay";
            objectArray2[1] = "com/intellij/openapi/editor/InlayModel$SimpleAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Listener
    extends EventListener {
        default public void onAdded(@NotNull Inlay<?> inlay) {
            if (inlay == null) {
                Listener.$$$reportNull$$$0(0);
            }
        }

        default public void onUpdated(@NotNull Inlay<?> inlay) {
            if (inlay == null) {
                Listener.$$$reportNull$$$0(1);
            }
        }

        default public void onUpdated(@NotNull Inlay<?> inlay, int changeFlags) {
            if (inlay == null) {
                Listener.$$$reportNull$$$0(2);
            }
            this.onUpdated(inlay);
        }

        default public void onRemoved(@NotNull Inlay<?> inlay) {
            if (inlay == null) {
                Listener.$$$reportNull$$$0(3);
            }
        }

        default public void onBatchModeStart(@NotNull Editor editor) {
            if (editor == null) {
                Listener.$$$reportNull$$$0(4);
            }
        }

        default public void onBatchModeFinish(@NotNull Editor editor) {
            if (editor == null) {
                Listener.$$$reportNull$$$0(5);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/InlayModel$Listener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onAdded";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onUpdated";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onRemoved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onBatchModeStart";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onBatchModeFinish";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

