/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.UtilBundle;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.LafIconLookup;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import icons.GithubIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHLabel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.GithubIssueState;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestRequestedReviewer;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestState;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.avatars.CachingGithubAvatarIconsProvider;
import org.jetbrains.plugins.github.util.CollectionDelta;
import org.jetbrains.plugins.github.util.GithubAsyncUtilKt;
import org.jetbrains.plugins.github.util.GithubUIUtil;
import org.jetbrains.plugins.github.util.GithubUIUtil$WhenMappings;
import org.jetbrains.plugins.github.util.GithubUIUtilKt$sam$com_intellij_openapi_util_Condition$0;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002>?B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#J\u0006\u0010%\u001a\u00020&J\u0016\u0010'\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\u0016\u0010+\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020(2\u0006\u0010)\u001a\u00020*J6\u0010,\u001a\u00020\u0010\"\b\b\u0000\u0010-*\u00020\u00132\u0006\u0010\u001a\u001a\u0002H-2\u0017\u0010.\u001a\u0013\u0012\u0004\u0012\u0002H-\u0012\u0004\u0012\u00020\u00100/\u00a2\u0006\u0002\b0\u00a2\u0006\u0002\u00101Jr\u00102\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H-0403\"\u0004\b\u0000\u0010-2\b\b\u0001\u00105\u001a\u00020\u00152\u0006\u00106\u001a\u00020\u00132$\u00107\u001a \u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H-0908\u0012\n\u0012\b\u0012\u0004\u0012\u0002H-0:0/2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002H-0<2\u0012\u0010=\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H-0<03R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006@"}, d2={"Lorg/jetbrains/plugins/github/util/GithubUIUtil;", "", "()V", "avatarSize", "Lcom/intellij/util/ui/JBValue;", "Lorg/jetbrains/annotations/NotNull;", "getAvatarSize", "()Lcom/intellij/util/ui/JBValue;", "createIssueLabelLabel", "Lcom/intellij/ui/components/JBLabel;", "label", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "createNoteWithAction", "Lcom/intellij/ui/SimpleColoredComponent;", "action", "Lkotlin/Function0;", "", "focusPanel", "panel", "Ljavax/swing/JComponent;", "formatActionDate", "", "date", "Ljava/util/Date;", "getFontEM", "", "component", "getIssueStateIcon", "Ljavax/swing/Icon;", "state", "Lorg/jetbrains/plugins/github/api/data/GithubIssueState;", "getIssueStateText", "getLabelBackground", "Lcom/intellij/ui/JBColor;", "getLabelForeground", "Ljava/awt/Color;", "bg", "getPRTimelineWidth", "", "getPullRequestStateIcon", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestState;", "isDraft", "", "getPullRequestStateText", "overrideUIDependentProperty", "T", "listener", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Ljavax/swing/JComponent;Lkotlin/jvm/functions/Function1;)V", "showChooserPopup", "Ljava/util/concurrent/CompletableFuture;", "Lorg/jetbrains/plugins/github/util/CollectionDelta;", "popupTitle", "parentComponent", "cellRendererFactory", "Ljavax/swing/JList;", "Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectableWrapper;", "Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectionListCellRenderer;", "currentList", "", "availableListFuture", "SelectableWrapper", "SelectionListCellRenderer", "intellij.vcs.github"})
public final class GithubUIUtil {
    @NotNull
    private static final JBValue avatarSize;
    public static final GithubUIUtil INSTANCE;

    @NotNull
    public final JBValue getAvatarSize() {
        return avatarSize;
    }

    @NotNull
    public final Icon getPullRequestStateIcon(@NotNull GHPullRequestState state2, boolean isDraft) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        if (isDraft) {
            Icon icon2 = GithubIcons.PullRequestDraft;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"GithubIcons.PullRequestDraft");
        } else {
            Icon icon3;
            switch (GithubUIUtil$WhenMappings.$EnumSwitchMapping$0[state2.ordinal()]) {
                case 1: {
                    icon3 = GithubIcons.PullRequestClosed;
                    break;
                }
                case 2: {
                    icon3 = GithubIcons.PullRequestMerged;
                    break;
                }
                case 3: {
                    icon3 = GithubIcons.PullRequestOpen;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"when (state) {\n      GHP\u2026ons.PullRequestOpen\n    }");
        }
        return icon;
    }

    @NotNull
    public final String getPullRequestStateText(@NotNull GHPullRequestState state2, boolean isDraft) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        if (isDraft) {
            String string2 = GithubBundle.message("pull.request.state.draft", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GithubBundle.message(\"pull.request.state.draft\")");
        } else {
            String string3;
            switch (GithubUIUtil$WhenMappings.$EnumSwitchMapping$1[state2.ordinal()]) {
                case 1: {
                    string3 = GithubBundle.message("pull.request.state.closed", new Object[0]);
                    break;
                }
                case 2: {
                    string3 = GithubBundle.message("pull.request.state.merged", new Object[0]);
                    break;
                }
                case 3: {
                    string3 = GithubBundle.message("pull.request.state.open", new Object[0]);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"when (state) {\n      GHP\u2026equest.state.open\")\n    }");
        }
        return string;
    }

    @NotNull
    public final Icon getIssueStateIcon(@NotNull GithubIssueState state2) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        switch (GithubUIUtil$WhenMappings.$EnumSwitchMapping$2[state2.ordinal()]) {
            case 1: {
                Icon icon2 = GithubIcons.IssueOpened;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"GithubIcons.IssueOpened");
                break;
            }
            case 2: {
                Icon icon3 = GithubIcons.IssueClosed;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"GithubIcons.IssueClosed");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return icon;
    }

    @NotNull
    public final String getIssueStateText(@NotNull GithubIssueState state2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        switch (GithubUIUtil$WhenMappings.$EnumSwitchMapping$3[state2.ordinal()]) {
            case 1: {
                String string2 = GithubBundle.message("issue.state.open", new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GithubBundle.message(\"issue.state.open\")");
                break;
            }
            case 2: {
                String string3 = GithubBundle.message("issue.state.closed", new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"GithubBundle.message(\"issue.state.closed\")");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public final <T extends JComponent> void overrideUIDependentProperty(@NotNull T component, @NotNull Function1<? super T, Unit> listener2) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        component.addPropertyChangeListener("UI", new PropertyChangeListener(listener2, component){
            final /* synthetic */ Function1 $listener;
            final /* synthetic */ JComponent $component;

            public final void propertyChange(PropertyChangeEvent it) {
                this.$listener.invoke((Object)this.$component);
            }
            {
                this.$listener = function1;
                this.$component = jComponent;
            }
        });
        listener2.invoke(component);
    }

    public final void focusPanel(@NotNull JComponent panel2) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        IdeFocusManager ideFocusManager = IdeFocusManager.findInstanceByComponent((Component)panel2);
        Intrinsics.checkNotNullExpressionValue((Object)ideFocusManager, (String)"IdeFocusManager.findInstanceByComponent(panel)");
        IdeFocusManager focusManager = ideFocusManager;
        JComponent jComponent = focusManager.getFocusTargetFor(panel2);
        if (jComponent == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"focusManager.getFocusTargetFor(panel) ?: return");
        JComponent toFocus = jComponent;
        focusManager.doWhenFocusSettlesDown(new Runnable(focusManager, toFocus){
            final /* synthetic */ IdeFocusManager $focusManager;
            final /* synthetic */ JComponent $toFocus;

            public final void run() {
                this.$focusManager.requestFocus((Component)this.$toFocus, true);
            }
            {
                this.$focusManager = ideFocusManager;
                this.$toFocus = jComponent;
            }
        });
    }

    @NotNull
    public final JBLabel createIssueLabelLabel(@NotNull GHLabel label2) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        JBLabel jBLabel = new JBLabel(' ' + label2.getName() + ' ', UIUtil.ComponentStyle.SMALL);
        boolean bl = false;
        boolean bl2 = false;
        JBLabel $this$apply = jBLabel;
        boolean bl3 = false;
        $this$apply.setBackground((Color)INSTANCE.getLabelBackground(label2));
        Color color = $this$apply.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background");
        $this$apply.setForeground(INSTANCE.getLabelForeground(color));
        JBLabel jBLabel2 = jBLabel.andOpaque();
        Intrinsics.checkNotNullExpressionValue((Object)jBLabel2, (String)"JBLabel(\" ${label.name} \u2026ckground)\n  }.andOpaque()");
        return jBLabel2;
    }

    @NotNull
    public final JBColor getLabelBackground(@NotNull GHLabel label2) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        Color color = ColorUtil.fromHex((String)label2.getColor());
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"ColorUtil.fromHex(label.color)");
        Color apiColor = color;
        return new JBColor(apiColor, ColorUtil.darker((Color)apiColor, (int)3));
    }

    @NotNull
    public final Color getLabelForeground(@NotNull Color bg) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)bg, (String)"bg");
        if (ColorUtil.isDark((Color)bg)) {
            Color color2 = Color.white;
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"Color.white");
        } else {
            Color color3 = Color.black;
            color = color3;
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"Color.black");
        }
        return color;
    }

    public final float getFontEM(@NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        FontMetrics metrics = component.getFontMetrics(component.getFont());
        return FontLayoutService.getInstance().charWidth2D(metrics, 8212);
    }

    @NotNull
    public final String formatActionDate(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        String string = DateFormatUtil.formatPrettyDate((Date)date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DateFormatUtil.formatPrettyDate(date)");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        String prettyDate = string4;
        String datePrefix = StringsKt.equals((String)prettyDate, (String)UtilBundle.message((String)"date.format.today", (Object[])new Object[0]), (boolean)true) || StringsKt.equals((String)prettyDate, (String)UtilBundle.message((String)"date.format.yesterday", (Object[])new Object[0]), (boolean)true) ? "" : "on ";
        return datePrefix + prettyDate;
    }

    @NotNull
    public final SimpleColoredComponent createNoteWithAction(@NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        SimpleColoredComponent simpleColoredComponent = new SimpleColoredComponent();
        boolean bl = false;
        boolean bl2 = false;
        SimpleColoredComponent $this$apply = simpleColoredComponent;
        boolean bl3 = false;
        $this$apply.setFocusable(true);
        $this$apply.setOpaque(false);
        LinkMouseListenerBase.installSingleTagOn((SimpleColoredComponent)$this$apply);
        $this$apply.registerKeyboardAction(new ActionListener(action2){
            final /* synthetic */ Function0 $action$inlined;
            {
                this.$action$inlined = function0;
            }

            public final void actionPerformed(ActionEvent it) {
                this.$action$inlined.invoke();
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        return simpleColoredComponent;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> CompletableFuture<CollectionDelta<T>> showChooserPopup(@NlsContexts.PopupTitle @NotNull String popupTitle, @NotNull JComponent parentComponent, @NotNull Function1<? super JList<SelectableWrapper<T>>, ? extends SelectionListCellRenderer<T>> cellRendererFactory, @NotNull List<? extends T> currentList, @NotNull CompletableFuture<List<T>> availableListFuture) {
        Collection<SelectableWrapper<void>> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)popupTitle, (String)"popupTitle");
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        Intrinsics.checkNotNullParameter(cellRendererFactory, (String)"cellRendererFactory");
        Intrinsics.checkNotNullParameter(currentList, (String)"currentList");
        Intrinsics.checkNotNullParameter(availableListFuture, (String)"availableListFuture");
        CollectionListModel listModel = new CollectionListModel((Object[])new SelectableWrapper[0]);
        JBList jBList = new JBList();
        boolean bl = false;
        boolean bl2 = false;
        JBList $this$apply = jBList;
        boolean $i$a$-apply-GithubUIUtil$showChooserPopup$list$22 = false;
        $this$apply.setVisibleRowCount(7);
        $this$apply.setFocusable(false);
        $this$apply.setSelectionMode(0);
        JBList list2 = jBList;
        SelectionListCellRenderer listCellRenderer = (SelectionListCellRenderer)cellRendererFactory.invoke((Object)list2);
        list2.setCellRenderer((ListCellRenderer)listCellRenderer);
        SpeedSearch speedSearch = new SpeedSearch();
        $this$apply = (Function1)new Function1<String, Boolean>(speedSearch){

            public final boolean invoke(String p1) {
                return ((SpeedSearch)this.receiver).shouldBeShowing(p1);
            }
        };
        NameFilteringListModel filteringListModel2 = new NameFilteringListModel((ListModel)listModel, new com.intellij.util.Function<SelectableWrapper<T>, String>(listCellRenderer){
            final /* synthetic */ SelectionListCellRenderer $listCellRenderer;

            public final String fun(SelectableWrapper<T> it) {
                return this.$listCellRenderer.getText(it.getValue());
            }
            {
                this.$listCellRenderer = selectionListCellRenderer;
            }
        }, (Condition)new GithubUIUtilKt$sam$com_intellij_openapi_util_Condition$0((Function1)$this$apply), (Computable)new Computable<String>(speedSearch){
            final /* synthetic */ SpeedSearch $speedSearch;

            public final String compute() {
                String string = this.$speedSearch.getFilter();
                if (string == null) {
                    string = "";
                }
                return string;
            }
            {
                this.$speedSearch = speedSearch;
            }
        });
        list2.setModel((ListModel)filteringListModel2);
        speedSearch.addChangeListener(new PropertyChangeListener(list2, filteringListModel2, speedSearch){
            final /* synthetic */ JBList $list;
            final /* synthetic */ NameFilteringListModel $filteringListModel;
            final /* synthetic */ SpeedSearch $speedSearch;

            public final void propertyChange(PropertyChangeEvent it) {
                SelectableWrapper prevSelection = (SelectableWrapper)this.$list.getSelectedValue();
                this.$filteringListModel.refilter();
                if (this.$filteringListModel.getSize() > 0) {
                    int fullMatchIndex;
                    int n = fullMatchIndex = this.$speedSearch.isHoldingFilter() ? this.$filteringListModel.getClosestMatchIndex() : this.$filteringListModel.getElementIndex((Object)prevSelection);
                    if (fullMatchIndex != -1) {
                        this.$list.setSelectedIndex(fullMatchIndex);
                    }
                    if (this.$filteringListModel.getSize() <= this.$list.getSelectedIndex() || !this.$filteringListModel.contains(this.$list.getSelectedValue())) {
                        this.$list.setSelectedIndex(0);
                    }
                }
            }
            {
                this.$list = jBList;
                this.$filteringListModel = nameFilteringListModel;
                this.$speedSearch = speedSearch;
            }
        });
        JScrollPane $i$a$-apply-GithubUIUtil$showChooserPopup$list$22 = ScrollPaneFactory.createScrollPane((Component)((Component)list2), (boolean)true);
        boolean bl3 = false;
        boolean bl4 = false;
        JScrollPane $this$apply22 = $i$a$-apply-GithubUIUtil$showChooserPopup$list$22;
        boolean bl5 = false;
        JViewport jViewport = $this$apply22.getViewport();
        Intrinsics.checkNotNullExpressionValue((Object)jViewport, (String)"viewport");
        jViewport.setCursor(Cursor.getPredefinedCursor(12));
        $this$apply22.setFocusable(false);
        JScrollPane jScrollPane = $i$a$-apply-GithubUIUtil$showChooserPopup$list$22;
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"ScrollPaneFactory.create\u2026isFocusable = false\n    }");
        JScrollPane scrollPane = jScrollPane;
        SearchTextField searchTextField = new SearchTextField(false);
        bl4 = false;
        boolean $this$apply22 = false;
        Object $this$apply3 = searchTextField;
        boolean bl6 = false;
        $this$apply3.setBorder(IdeBorderFactory.createBorder((int)8));
        UIUtil.setBackgroundRecursively((Component)((Component)$this$apply3), (Color)UIUtil.getListBackground());
        JBTextField jBTextField = $this$apply3.getTextEditor();
        Intrinsics.checkNotNullExpressionValue((Object)jBTextField, (String)"textEditor");
        jBTextField.setBorder((Border)JBUI.Borders.empty());
        $this$apply3.setFocusable(false);
        $this$apply3.addDocumentListener((DocumentListener)new DocumentAdapter((SearchTextField)$this$apply3, speedSearch){
            final /* synthetic */ SearchTextField $this_apply;
            final /* synthetic */ SpeedSearch $speedSearch$inlined;
            {
                this.$this_apply = $receiver;
                this.$speedSearch$inlined = speedSearch;
            }

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$speedSearch$inlined.updatePattern(this.$this_apply.getText());
            }
        });
        SearchTextField searchField2 = searchTextField;
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel((Component)scrollPane).addToTop((Component)searchField2);
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel, (String)"JBUI.Panels.simplePanel(\u2026ne).addToTop(searchField)");
        BorderLayoutPanel panel2 = borderLayoutPanel;
        ScrollingUtil.installActions((JList)((JList)list2), (JComponent)((JComponent)panel2));
        ListUtil.installAutoSelectOnMouseMove((JList)((JList)list2));
        Function0<Unit> $fun$toggleSelection$2 = new Function0<Unit>(list2){
            final /* synthetic */ JBList $list;

            public final void invoke() {
                Iterator<E> iterator = this.$list.getSelectedValuesList().iterator();
                while (iterator.hasNext()) {
                    SelectableWrapper item;
                    item.setSelected(!(item = (SelectableWrapper)iterator.next()).getSelected());
                }
                this.$list.repaint();
            }
            {
                this.$list = jBList;
                super(0);
            }
        };
        list2.addMouseListener((MouseListener)new MouseAdapter($fun$toggleSelection$2){
            final /* synthetic */ showChooserPopup.2 $toggleSelection$2;

            public void mouseReleased(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (UIUtil.isActionClick((MouseEvent)e, (int)502) && !UIUtil.isSelectionButtonDown((MouseEvent)e) && !e.isConsumed()) {
                    this.$toggleSelection$2.invoke();
                }
            }
            {
                this.$toggleSelection$2 = $captured_local_variable$0;
            }
        });
        Set originalSelection = CollectionsKt.toHashSet((Iterable)currentList);
        $this$apply3 = currentList;
        CollectionListModel collectionListModel = listModel;
        boolean $i$f$map = false;
        void var18_27 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl7 = false;
            SelectableWrapper<void> selectableWrapper = new SelectableWrapper<void>(it, true);
            collection.add(selectableWrapper);
        }
        collection = (List)destination$iv$iv;
        collectionListModel.add((List)collection);
        CompletableFuture<CollectionDelta<T>> result = new CompletableFuture<CollectionDelta<T>>();
        JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel2, (JComponent)searchField2).setRequestFocus(true).setCancelOnClickOutside(true).setTitle(popupTitle).setResizable(true).setMovable(true).setKeyboardActions(CollectionsKt.listOf((Object)Pair.create((Object)new ActionListener($fun$toggleSelection$2){
            final /* synthetic */ showChooserPopup.2 $toggleSelection$2;

            public final void actionPerformed(ActionEvent it) {
                this.$toggleSelection$2.invoke();
            }
            {
                this.$toggleSelection$2 = var1_1;
            }
        }, (Object)KeyStroke.getKeyStroke(10, 0)))).addListener(new JBPopupListener(list2, availableListFuture, originalSelection, listCellRenderer, listModel, result){
            final /* synthetic */ JBList $list;
            final /* synthetic */ CompletableFuture $availableListFuture;
            final /* synthetic */ Set $originalSelection;
            final /* synthetic */ SelectionListCellRenderer $listCellRenderer;
            final /* synthetic */ CollectionListModel $listModel;
            final /* synthetic */ CompletableFuture $result;

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$list.setPaintBusy(true);
                StatusText statusText = this.$list.getEmptyText();
                Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"list.emptyText");
                statusText.setText(ApplicationBundle.message((String)"label.loading.page.please.wait", (Object[])new Object[0]));
                CompletionStage completionStage = this.$availableListFuture.thenApplyAsync(new Function<List<? extends T>, List<? extends SelectableWrapper<T>>>(this){
                    final /* synthetic */ showChooserPopup.6 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final List<SelectableWrapper<T>> apply(List<? extends T> available) {
                        void $this$mapTo$iv$iv;
                        List<? extends T> list2 = available;
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"available");
                        Iterable $this$map$iv = list2;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            void it;
                            T item$iv$iv;
                            T t = item$iv$iv = iterator.next();
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            SelectableWrapper<void> selectableWrapper = new SelectableWrapper<void>(it, this.this$0.$originalSelection.contains(it));
                            collection.add(selectableWrapper);
                        }
                        Iterable iterable2 = (List)destination$iv$iv;
                        Comparator<T> comparator = Comparator.comparing(showChooserPopup.beforeShown.2.INSTANCE).thenComparing((Function)new Function<SelectableWrapper<T>, String>(this){
                            final /* synthetic */ showChooserPopup.beforeShown.1 this$0;

                            public final String apply(SelectableWrapper<T> it) {
                                return this.this$0.this$0.$listCellRenderer.getText(it.getValue());
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }, showChooserPopup.beforeShown.4.INSTANCE);
                        Intrinsics.checkNotNullExpressionValue(comparator, (String)"Comparator.comparing<Sel\u2026til.compare(a, b, true) }");
                        return CollectionsKt.sortedWith((Iterable)iterable2, comparator);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"availableListFuture\n    \u2026b, true) })\n            }");
                GithubAsyncUtilKt.successOnEdt$default((CompletableFuture)completionStage, null, (Function1)new Function1<List<? extends SelectableWrapper<T>>, Unit>(this, event){
                    final /* synthetic */ showChooserPopup.6 this$0;
                    final /* synthetic */ LightweightWindowEvent $event;

                    public final void invoke(List<SelectableWrapper<T>> it) {
                        this.this$0.$listModel.replaceAll(it);
                        this.this$0.$list.setPaintBusy(false);
                        StatusText statusText = this.this$0.$list.getEmptyText();
                        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"list.emptyText");
                        statusText.setText(UIBundle.message((String)"message.noMatchesFound", (Object[])new Object[0]));
                        this.$event.asPopup().pack(true, true);
                        if (this.this$0.$list.getSelectedIndex() == -1) {
                            this.this$0.$list.setSelectedIndex(0);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$event = lightweightWindowEvent;
                        super(1);
                    }
                }, 1, null);
            }

            /*
             * WARNING - void declaration
             */
            public void onClosed(@NotNull LightweightWindowEvent event) {
                void $this$mapTo$iv$iv;
                SelectableWrapper it;
                Iterable $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                List list2 = this.$listModel.getItems();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"listModel.items");
                Iterable $this$filter$iv = list2;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (SelectableWrapper)element$iv$iv;
                    boolean bl = false;
                    if (!it.getSelected()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (SelectableWrapper)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    T t = it.getValue();
                    collection.add(t);
                }
                List selected = (List)destination$iv$iv;
                this.$result.complete(new CollectionDelta<T>(this.$originalSelection, selected));
            }
            {
                this.$list = $captured_local_variable$0;
                this.$availableListFuture = $captured_local_variable$1;
                this.$originalSelection = $captured_local_variable$2;
                this.$listCellRenderer = $captured_local_variable$3;
                this.$listModel = $captured_local_variable$4;
                this.$result = $captured_local_variable$5;
            }
        }).createPopup().showUnderneathOf((Component)parentComponent);
        return result;
    }

    public final int getPRTimelineWidth() {
        return (int)(this.getFontEM(new JLabel()) * (float)42);
    }

    private GithubUIUtil() {
    }

    static {
        GithubUIUtil githubUIUtil;
        INSTANCE = githubUIUtil = new GithubUIUtil();
        JBValue jBValue = JBUI.uiIntValue((String)"Github.Avatar.Size", (int)20);
        Intrinsics.checkNotNullExpressionValue((Object)jBValue, (String)"JBUI.uiIntValue(\"Github.Avatar.Size\", 20)");
        avatarSize = jBValue;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000e\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J(\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectableWrapper;", "T", "", "value", "selected", "", "(Ljava/lang/Object;Z)V", "getSelected", "()Z", "setSelected", "(Z)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "copy", "(Ljava/lang/Object;Z)Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectableWrapper;", "equals", "other", "hashCode", "", "toString", "", "intellij.vcs.github"})
    public static final class SelectableWrapper<T> {
        private final T value;
        private boolean selected;

        public final T getValue() {
            return this.value;
        }

        public final boolean getSelected() {
            return this.selected;
        }

        public final void setSelected(boolean bl) {
            this.selected = bl;
        }

        public SelectableWrapper(T value, boolean selected) {
            this.value = value;
            this.selected = selected;
        }

        public /* synthetic */ SelectableWrapper(Object object, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(object, bl);
        }

        public final T component1() {
            return this.value;
        }

        public final boolean component2() {
            return this.selected;
        }

        @NotNull
        public final SelectableWrapper<T> copy(T value, boolean selected) {
            return new SelectableWrapper<T>(value, selected);
        }

        public static /* synthetic */ SelectableWrapper copy$default(SelectableWrapper selectableWrapper, Object object, boolean bl, int n, Object object2) {
            if ((n & 1) != 0) {
                object = selectableWrapper.value;
            }
            if ((n & 2) != 0) {
                bl = selectableWrapper.selected;
            }
            return selectableWrapper.copy(object, bl);
        }

        @NotNull
        public String toString() {
            return "SelectableWrapper(value=" + this.value + ", selected=" + this.selected + ")";
        }

        public int hashCode() {
            T t = this.value;
            int n = (t != null ? t.hashCode() : 0) * 31;
            int n2 = this.selected ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SelectableWrapper)) break block3;
                    SelectableWrapper selectableWrapper = (SelectableWrapper)object;
                    if (!Intrinsics.areEqual(this.value, selectableWrapper.value) || this.selected != selectableWrapper.selected) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u00022\u00020\u0004:\u0003\u0019\u001a\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\fJD\u0010\r\u001a\u00020\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u00102\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00028\u0000H'\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0003\u001c\u001d\u001e\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectionListCellRenderer;", "T", "Ljavax/swing/ListCellRenderer;", "Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectableWrapper;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "()V", "checkIconLabel", "Ljavax/swing/JLabel;", "mainLabel", "getIcon", "Ljavax/swing/Icon;", "value", "(Ljava/lang/Object;)Ljavax/swing/Icon;", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "index", "", "isSelected", "", "cellHasFocus", "getText", "", "(Ljava/lang/Object;)Ljava/lang/String;", "Labels", "PRReviewers", "Users", "Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectionListCellRenderer$PRReviewers;", "Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectionListCellRenderer$Users;", "Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectionListCellRenderer$Labels;", "intellij.vcs.github"})
    public static abstract class SelectionListCellRenderer<T>
    extends BorderLayoutPanel
    implements ListCellRenderer<SelectableWrapper<T>> {
        private final JLabel mainLabel = new JLabel();
        private final JLabel checkIconLabel = new JLabel();

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList<? extends SelectableWrapper<T>> list2, @NotNull SelectableWrapper<T> value, int index, boolean isSelected, boolean cellHasFocus) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            Intrinsics.checkNotNullParameter(value, (String)"value");
            this.setForeground(UIUtil.getListForeground((boolean)isSelected, (boolean)true));
            this.setBackground(UIUtil.getListBackground((boolean)isSelected, (boolean)true));
            this.mainLabel.setForeground(this.getForeground());
            this.mainLabel.setFont(this.getFont());
            this.mainLabel.setText(this.getText(value.getValue()));
            this.mainLabel.setIcon(this.getIcon(value.getValue()));
            Icon icon = LafIconLookup.getIcon$default((String)"checkmark", (boolean)isSelected, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (int)56, null);
            this.checkIconLabel.setIcon(value.getSelected() ? icon : (Icon)EmptyIcon.create((Icon)icon));
            return (Component)((Object)this);
        }

        @NlsContexts.Label
        @NotNull
        public abstract String getText(T var1);

        @NotNull
        public abstract Icon getIcon(T var1);

        private SelectionListCellRenderer() {
            this.checkIconLabel.setIconTextGap(JBUI.scale((int)4));
            this.checkIconLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
            this.addToLeft(this.checkIconLabel);
            this.addToCenter(this.mainLabel);
            this.setBorder((Border)JBUI.Borders.empty((int)4, (int)0));
        }

        public /* synthetic */ SelectionListCellRenderer(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectionListCellRenderer$PRReviewers;", "Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectionListCellRenderer;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestRequestedReviewer;", "iconsProvider", "Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider;", "(Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider;)V", "getIcon", "Ljavax/swing/Icon;", "value", "getText", "", "intellij.vcs.github"})
        public static final class PRReviewers
        extends SelectionListCellRenderer<GHPullRequestRequestedReviewer> {
            private final CachingGithubAvatarIconsProvider iconsProvider;

            @Override
            @NotNull
            public String getText(@NotNull GHPullRequestRequestedReviewer value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value.getShortName();
            }

            @Override
            @NotNull
            public Icon getIcon(@NotNull GHPullRequestRequestedReviewer value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return this.iconsProvider.getIcon(value.getAvatarUrl());
            }

            public PRReviewers(@NotNull CachingGithubAvatarIconsProvider iconsProvider) {
                Intrinsics.checkNotNullParameter((Object)iconsProvider, (String)"iconsProvider");
                super(null);
                this.iconsProvider = iconsProvider;
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectionListCellRenderer$Users;", "Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectionListCellRenderer;", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "iconsProvider", "Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider;", "(Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider;)V", "getIcon", "Ljavax/swing/Icon;", "value", "getText", "", "intellij.vcs.github"})
        public static final class Users
        extends SelectionListCellRenderer<GHUser> {
            private final CachingGithubAvatarIconsProvider iconsProvider;

            @Override
            @NotNull
            public String getText(@NotNull GHUser value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value.getLogin();
            }

            @Override
            @NotNull
            public Icon getIcon(@NotNull GHUser value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return this.iconsProvider.getIcon(value.getAvatarUrl());
            }

            public Users(@NotNull CachingGithubAvatarIconsProvider iconsProvider) {
                Intrinsics.checkNotNullParameter((Object)iconsProvider, (String)"iconsProvider");
                super(null);
                this.iconsProvider = iconsProvider;
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectionListCellRenderer$Labels;", "Lorg/jetbrains/plugins/github/util/GithubUIUtil$SelectionListCellRenderer;", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "()V", "getIcon", "Lcom/intellij/util/ui/ColorIcon;", "value", "getText", "", "intellij.vcs.github"})
        public static final class Labels
        extends SelectionListCellRenderer<GHLabel> {
            @Override
            @NotNull
            public String getText(@NotNull GHLabel value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value.getName();
            }

            @NotNull
            public ColorIcon getIcon(@NotNull GHLabel value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new ColorIcon(16, ColorUtil.fromHex((String)value.getColor()));
            }

            public Labels() {
                super(null);
            }
        }
    }
}

