/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.languagetool.AnalyzedSentence;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.rules.RemoteRuleConfig;
import org.languagetool.rules.RemoteRuleMetrics;
import org.languagetool.rules.RemoteRuleResult;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemoteRule
extends Rule {
    private static final Logger logger = LoggerFactory.getLogger(RemoteRule.class);
    private static final ConcurrentMap<String, Long> lastFailure = new ConcurrentHashMap<String, Long>();
    private static final ConcurrentMap<String, AtomicInteger> consecutiveFailures = new ConcurrentHashMap<String, AtomicInteger>();
    private static final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("remote-rule-pool-{}").setDaemon(true).build();
    protected static final List<Runnable> shutdownRoutines = new LinkedList<Runnable>();
    private static final ConcurrentMap<String, ExecutorService> executors = new ConcurrentHashMap<String, ExecutorService>();
    protected final RemoteRuleConfig serviceConfiguration;
    private AnnotatedText annotatedText;

    public RemoteRule(ResourceBundle messages, RemoteRuleConfig config) {
        super(messages);
        this.serviceConfiguration = config;
        String ruleId = this.getId();
        lastFailure.putIfAbsent(ruleId, 0L);
        consecutiveFailures.putIfAbsent(ruleId, new AtomicInteger());
        executors.putIfAbsent(ruleId, Executors.newCachedThreadPool(threadFactory));
    }

    public static void shutdown() {
        shutdownRoutines.forEach(Runnable::run);
    }

    protected abstract RemoteRequest prepareRequest(List<AnalyzedSentence> var1, AnnotatedText var2);

    protected abstract Callable<RemoteRuleResult> executeRequest(RemoteRequest var1);

    protected abstract RemoteRuleResult fallbackResults(RemoteRequest var1);

    public FutureTask<List<RuleMatch>> run(List<AnalyzedSentence> sentences, AnnotatedText annotatedText) {
        this.annotatedText = annotatedText;
        return new FutureTask<List<RuleMatch>>(() -> {
            long failureInterval;
            long startTime = System.nanoTime();
            long characters = sentences.stream().mapToInt(sentence -> sentence.getText().length()).sum();
            String ruleId = this.getId();
            RemoteRequest req = this.prepareRequest(sentences, annotatedText);
            if (((AtomicInteger)consecutiveFailures.get(ruleId)).get() >= this.serviceConfiguration.getFall() && (failureInterval = System.currentTimeMillis() - (Long)lastFailure.get(ruleId)) < this.serviceConfiguration.getDownMilliseconds()) {
                RemoteRuleMetrics.request(ruleId, 0, 0L, characters, RemoteRuleMetrics.RequestResult.DOWN);
                RemoteRuleResult result = this.fallbackResults(req);
                return result.getMatches();
            }
            RemoteRuleMetrics.up(ruleId, true);
            for (int i = 0; i <= this.serviceConfiguration.getMaxRetries(); ++i) {
                Callable<RemoteRuleResult> task = this.executeRequest(req);
                long timeout = this.serviceConfiguration.getBaseTimeoutMilliseconds() + (long)Math.round((float)characters * this.serviceConfiguration.getTimeoutPerCharacterMilliseconds());
                try {
                    Future<RemoteRuleResult> future = ((ExecutorService)executors.get(ruleId)).submit(task);
                    RemoteRuleResult result = timeout <= 0L ? future.get() : future.get(timeout, TimeUnit.MILLISECONDS);
                    future.cancel(true);
                    if (result.isRemote()) {
                        ((AtomicInteger)consecutiveFailures.get(ruleId)).set(0);
                        RemoteRuleMetrics.failures(ruleId, 0);
                    }
                    RemoteRuleMetrics.RequestResult requestResult = result.isRemote() ? RemoteRuleMetrics.RequestResult.SUCCESS : RemoteRuleMetrics.RequestResult.SKIPPED;
                    RemoteRuleMetrics.request(ruleId, i, System.nanoTime() - startTime, characters, requestResult);
                    return result.getMatches();
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    logger.warn("Error while fetching results for remote rule " + ruleId + ", tried " + (i + 1) + " times, timeout: " + timeout + "ms", (Throwable)e);
                    RemoteRuleMetrics.RequestResult status = e instanceof TimeoutException || e instanceof InterruptedException ? RemoteRuleMetrics.RequestResult.TIMEOUT : RemoteRuleMetrics.RequestResult.ERROR;
                    RemoteRuleMetrics.request(ruleId, i, System.nanoTime() - startTime, characters, status);
                    continue;
                }
            }
            RemoteRuleMetrics.failures(ruleId, ((AtomicInteger)consecutiveFailures.get(ruleId)).incrementAndGet());
            logger.warn("Fetching results for remote rule " + ruleId + " failed.");
            if (((AtomicInteger)consecutiveFailures.get(ruleId)).get() >= this.serviceConfiguration.getFall()) {
                lastFailure.put(ruleId, System.currentTimeMillis());
                logger.warn("Remote rule " + ruleId + " marked as DOWN.");
                RemoteRuleMetrics.downtime(ruleId, this.serviceConfiguration.getDownMilliseconds());
                RemoteRuleMetrics.up(ruleId, false);
            }
            RemoteRuleResult result = this.fallbackResults(req);
            return result.getMatches();
        });
    }

    @Override
    public String getId() {
        return this.serviceConfiguration.getRuleId();
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        FutureTask<List<RuleMatch>> task = this.run(Collections.singletonList(sentence), this.annotatedText);
        task.run();
        try {
            return task.get().toArray(new RuleMatch[0]);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.warn("Fetching results for remote rule " + this.getId() + " failed.", (Throwable)e);
            return new RuleMatch[0];
        }
    }

    protected class RemoteRequest {
        protected RemoteRequest() {
        }
    }
}

